% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/take.R
\name{take}
\alias{take}
\alias{take_}
\alias{take_.data.frame}
\alias{take_.tbl_df}
\title{Subset data frames}
\usage{
take(.data, .condition, ...)

take_(.data, .condition, ..., .dots)

\method{take_}{data.frame}(.data, .condition, ..., .dots)

\method{take_}{tbl_df}(.data, .condition, ..., .dots)
}
\arguments{
\item{.data}{A tbl or data.frame.}

\item{.condition}{A condition defining the \code{\link[dplyr]{filter}} to be applied on 
\code{.data}.}

\item{...}{Variable names to be \code{\link[dplyr]{select}}ed.}

\item{.dots}{character vector of variable names to be \code{\link[dplyr]{select}}ed.}
}
\value{
A tbl or data.frame
}
\description{
Return subset of a data frame which meets conditions.
}
\examples{
df <- mtcars[1:10,]
take(df, cyl \%in\% c(4, 6), mpg, disp)
take_(df, ~ cyl \%in\% c(4, 6), ~ mpg, ~ disp)
take_(df, ~ cyl \%in\% c(4, 6), .dots = c("mpg", "disp"))

}
\seealso{
\code{\link[dplyr]{filter}} and \code{\link[dplyr]{select}} 
from package \pkg{dplyr}.
}
