% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDesignMeans.R
\name{getDesignMeanRatioEquiv}
\alias{getDesignMeanRatioEquiv}
\title{Group sequential design for equivalence in two-sample
mean ratio}
\usage{
getDesignMeanRatioEquiv(
  beta = NA_real_,
  n = NA_real_,
  meanRatioLower = NA_real_,
  meanRatioUpper = NA_real_,
  meanRatio = 1,
  CV = 1,
  allocationRatioPlanned = 1,
  normalApproximation = TRUE,
  rounding = TRUE,
  kMax = 1L,
  informationRates = NA_real_,
  alpha = 0.05,
  typeAlphaSpending = "sfOF",
  parameterAlphaSpending = NA_real_,
  userAlphaSpending = NA_real_,
  spendingTime = NA_real_
)
}
\arguments{
\item{beta}{The type II error.}

\item{n}{The total sample size.}

\item{meanRatioLower}{The lower equivalence limit of mean ratio.}

\item{meanRatioUpper}{The upper equivalence limit of mean ratio.}

\item{meanRatio}{The mean ratio under the alternative hypothesis.}

\item{CV}{The coefficient of variation.}

\item{allocationRatioPlanned}{Allocation ratio for the active treatment
versus control. Defaults to 1 for equal randomization.}

\item{normalApproximation}{The type of computation of the p-values.
If \code{TRUE}, the variance is assumed to be known, otherwise
the calculations are performed with the t distribution. The exact
calculation using the t distribution is only implemented for the
fixed design.}

\item{rounding}{Whether to round up sample size. Defaults to 1 for
sample size rounding.}

\item{kMax}{The maximum number of stages.}

\item{informationRates}{The information rates. Fixed prior to the trial.
Defaults to \code{(1:kMax) / kMax} if left unspecified.}

\item{alpha}{The significance level for each of the two one-sided
tests. Defaults to 0.05.}

\item{typeAlphaSpending}{The type of alpha spending. One of the following:
"OF" for O'Brien-Fleming boundaries, "P" for Pocock boundaries,
"WT" for Wang & Tsiatis boundaries, "sfOF" for O'Brien-Fleming type
spending function, "sfP" for Pocock type spending function,
"sfKD" for Kim & DeMets spending function, "sfHSD" for Hwang,
Shi & DeCani spending function, "user" for user defined spending,
and "none" for no early efficacy stopping. Defaults to "sfOF".}

\item{parameterAlphaSpending}{The parameter value for the alpha spending.
Corresponds to Delta for "WT", rho for "sfKD", and gamma for "sfHSD".}

\item{userAlphaSpending}{The user defined alpha spending. Cumulative alpha
spent up to each stage.}

\item{spendingTime}{A vector of length \code{kMax} for the error spending
time at each analysis. Defaults to missing, in which case, it is the
same as \code{informationRates}.}
}
\value{
An S3 class \code{designMeanRatioEquiv} object with three
components:
\itemize{
\item \code{overallResults}: A data frame containing the following variables:
\itemize{
\item \code{overallReject}: The overall rejection probability.
\item \code{alpha}: The significance level for each of the two one-sided
tests. Defaults to 0.05.
\item \code{attainedAlpha}: The attained significance level.
\item \code{kMax}: The number of stages.
\item \code{information}: The maximum information.
\item \code{expectedInformationH1}: The expected information under H1.
\item \code{expectedInformationH0}: The expected information under H0.
\item \code{numberOfSubjects}: The maximum number of subjects.
\item \code{expectedNumberOfSubjectsH1}: The expected number of subjects
under H1.
\item \code{expectedNumberOfSubjectsH0}: The expected number of subjects
under H0.
\item \code{meanRatioLower}: The lower equivalence limit of mean ratio.
\item \code{meanRatioUpper}: The upper equivalence limit of mean ratio.
\item \code{meanRatio}: The mean ratio under the alternative hypothesis.
\item \code{CV}: The coefficient of variation.
}
\item \code{byStageResults}: A data frame containing the following variables:
\itemize{
\item \code{informationRates}: The information rates.
\item \code{efficacyBounds}: The efficacy boundaries on the Z-scale for
each of the two one-sided tests.
\item \code{rejectPerStage}: The probability for efficacy stopping.
\item \code{cumulativeRejection}: The cumulative probability for efficacy
stopping.
\item \code{cumulativeAlphaSpent}: The cumulative alpha for each of
the two one-sided tests.
\item \code{cumulativeAttainedAlpha}: The cumulative probability for
efficacy stopping under H0.
\item \code{efficacyP}: The efficacy bounds on the p-value scale for
each of the two one-sided tests.
\item \code{information}: The cumulative information.
\item \code{numberOfSubjects}: The number of subjects.
\item \code{efficacyMeanRatioLower}: The efficacy boundaries on the
mean ratio scale for the one-sided null hypothesis on the
lower equivalence limit.
\item \code{efficacyMeanRatioUpper}: The efficacy boundaries on the
mean ratio scale for the one-sided null hypothesis on the
upper equivalence limit.
}
\item \code{settings}: A list containing the following input parameters:
\itemize{
\item \code{typeAlphaSpending}: The type of alpha spending.
\item \code{parameterAlphaSpending}: The parameter value for alpha
spending.
\item \code{userAlphaSpending}: The user defined alpha spending.
\item \code{spendingTime}: The error spending time at each analysis.
\item \code{calculationTarget}: The calculation target, \code{beta} or
\code{n}.
\item \code{allocationRatioPlanned}: Allocation ratio for the active
treatment versus control.
\item \code{normalApproximation}: The type of computation of the p-values.
If \code{TRUE}, the variance is assumed to be known, otherwise
the calculations are performed with the t distribution. The exact
calculation using the t distribution is only implemented for the
fixed design.
\item \code{rounding}: Whether to round up sample size.
}
}
}
\description{
Obtains the power given sample size or obtains the sample
size given power for a group sequential design for equivalence in
two-sample mean ratio.
}
\examples{

# Example 1: group sequential trial power calculation
(design1 <- getDesignMeanRatioEquiv(
  beta = 0.1, n = NA, meanRatioLower = 0.8, meanRatioUpper = 1.25,
  meanRatio = 1, CV = 0.35,
  kMax = 4, alpha = 0.05, typeAlphaSpending = "sfOF"))

# Example 2: sample size calculation for t-test
(design2 <- getDesignMeanRatioEquiv(
  beta = 0.1, n = NA, meanRatioLower = 0.8, meanRatioUpper = 1.25,
  meanRatio = 1, CV = 0.35,
  normalApproximation = FALSE, alpha = 0.05))

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
