% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palette_ggdemo.R
\name{palette_ggdemo}
\alias{palette_ggdemo}
\title{Demonstrate Extracted Palette with HEX Labels - ggplot2 Edition}
\usage{
palette_ggdemo(palette)
}
\arguments{
\item{palette}{(character) Vector of hexadecimal codes returned by `palette_extract()`, `..._sort()`, or `..._subsample()`}
}
\value{
A ggplot2 plot
}
\description{
Accepts the hexadecimal code vector returned by `palette_extract()`, `..._sort()`, or `..._subsample()` and creates a simple plot of all returned colors labeled with their HEX codes. This will facilitate (hopefully) your selection of which of the 25 colors you would like to use in a given context.
}
\examples{
# Extract colors from a supplied image
my_colors <- palette_extract(image = system.file("extdata", "lyon-fire.png",
package = "lterpalettefinder"))
       
# Plot that result
palette_ggdemo(palette = my_colors)

}
