% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.r
\name{ymd}
\alias{dmy}
\alias{dym}
\alias{mdy}
\alias{myd}
\alias{ydm}
\alias{yearmonthdate}
\alias{ymd}
\title{Parse dates according to the order in that year, month, and day elements
appear in the input vector.}
\usage{
ymd(..., quiet = FALSE, tz = NULL, locale = Sys.getlocale("LC_TIME"),
  truncated = 0)
}
\arguments{
\item{...}{a character or numeric vector of suspected dates}

\item{quiet}{logical. When TRUE function evalueates without displaying
customary messages.}

\item{tz}{Time zone indicator. If NULL (default) a Date object is
returned. Otherwise a POSIXct with time zone attribute set to \code{tz}.}

\item{locale}{locale to be used, see \link{locales}. On linux systems you
can use \code{system("locale -a")} to list all the installed locales.}

\item{truncated}{integer. Number of formats that can be truncated.}
}
\value{
a vector of class POSIXct if tz argument is non-NULL or Date if tz
  is NULL (default)
}
\description{
Transforms dates stored in character and numeric vectors to POSIXct
objects. These functions recognize arbitrary non-digit separators as well as
no separator. As long as the order of formats is correct, these functions
will parse dates correctly even when the input vectors contain differently
formatted dates. See examples.
}
\details{
\code{ymd} family of functions automatically assign the Universal
Coordinated Time Zone (UTC) to the parsed dates. This time zone can be
changed with \code{\link{force_tz}}.

If \code{truncated} parameter is non-zero \code{ymd} functions also check for
truncated formats. For example \code{ymd} with \code{truncated = 2} will also
parse incomplete dates like \code{2012-06} and \code{2012}.

NOTE: \code{ymd} family of functions are based on `parse_date_time` and thus
directly drop to internal C parser for numeric months, but use R's
`strptime` for alphabetic months. This implies that some of the `strptime`'s
limitations are inherited by lubridate's parser. For example truncated
formats (like %Y-%b) will not be parsed. Numeric truncated formats (like
%Y-%m) are handled correctly by lubridate's C parser.

As of version 1.3.0, lubridate's parse functions no longer return a
message that displays which format they used to parse their input. You can
change this by setting the \code{lubridate.verbose} option to TRUE with
\code{options(lubridate.verbose = TRUE)}.
}
\examples{
x <- c("09-01-01", "09-01-02", "09-01-03")
ymd(x)
## "2009-01-01 UTC" "2009-01-02 UTC" "2009-01-03 UTC"
x <- c("2009-01-01", "2009-01-02", "2009-01-03")
ymd(x)
## "2009-01-01 UTC" "2009-01-02 UTC" "2009-01-03 UTC"
ymd(090101, 90102)
## "2009-01-01 UTC" "2009-01-02 UTC"
now() > ymd(20090101)
## TRUE
dmy(010210)
mdy(010210)

## heterogenuous formats in a single vector:
x <- c(20090101, "2009-01-02", "2009 01 03", "2009-1-4",
       "2009-1, 5", "Created on 2009 1 6", "200901 !!! 07")
ymd(x)

## What lubridate might not handle:

## Extremely weird cases when one of the separators is "" and some of the
## formats are not in double digits might not be parsed correctly:
\dontrun{ymd("201002-01", "201002-1", "20102-1")
dmy("0312-2010", "312-2010")}
}
\seealso{
\code{\link{parse_date_time}} for an even more flexible low level
  mechanism.
}
\keyword{chron}

