% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/partition.R
\name{partition}
\alias{partition}
\title{Partition raster data}
\usage{
partition(x, size = 0.5, spatial = TRUE, ...)
}
\arguments{
\item{x}{RasterLayer with categorical data}

\item{size}{numeric value between zero and one indicating the proportion of
non-NA cells that should be included in the training partition. Default is
0.5, which results in equally sized partitions}

\item{spatial}{logical. If TRUE, the function returns a SpatialPoints object
with the coordinates of cells in each partition. If FALSE, the cell numbers
are returned}

\item{\dots}{additional arguments (none)}
}
\value{
A list containing the following components:
\describe{
  \item{\code{train}}{a SpatialPoints object or numeric vector indicating the
  cells in the training partition}
  \item{\code{test}}{a SpatialPoints object or numeric vector indicating the
  cells in the testing partition}
  \item{\code{all}}{a SpatialPoints object or numeric vector indicating all
  non-NA cells in the study region}
}
}
\description{
Divide a categorical raster map into training and testing partitions.
A wrapper function for \cr
\code{caret::\link[caret]{createDataPartition}} (Kuhn, 2008) to divide a
categorical raster map into training and testing partitions.
}
\examples{
\dontrun{

## Plum Island Ecosystems

## Load observed land use maps
obs <- ObsLulcRasterStack(x=pie,
                   pattern="lu",
                   categories=c(1,2,3),
                   labels=c("forest","built","other"),
                   t=c(0,6,14))

## create equally sized training and testing partitions
part <- partition(x=obs[[1]], size=0.1, spatial=FALSE)
names(part)

}
}
\references{
Kuhn, M. (2008). Building predictive models in R using the caret
package. Journal of Statistical Software, 28(5), 1-26.
}
\seealso{
\code{caret::\link[caret]{createDataPartition}}
}

