% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmi.R
\name{bmi_cat}
\alias{bmi_cat}
\title{Classify body mass index (BMI) category}
\usage{
bmi_cat(bmi)
}
\arguments{
\item{bmi}{A numeric vector with BMI data. \code{BMI} unit must be meters per
square meter.}
}
\value{
A vector of class \code{factor} with 6 levels: "Underweight",
"Normal weight", "Overweight", "Obesity class I", "Obesity class II"
and "Obesity class III".
}
\description{
\code{bmi_cat} returns the element-wise BMI category as factor with 6 levels:
\itemize{
\item Underweight (18.5 < BMI)
\item Normal weight (18.5 \eqn{\le} BMI < 25)
\item Overweight (25 \eqn{\le} BMI < 30)
\item Obesity class I (30 \eqn{\le} BMI < 35)
\item Obesity class II (35 \eqn{\le} BMI < 40)
\item Obesity class III (BMI \eqn{\ge} 40)
}
}
\examples{
mass <- sample(50:100, 20)
height <- rnorm(20, mean = 1.7, sd = 0.2)
bmi <- bmi(mass, height)

bmi_cat(bmi)
}
\seealso{
\code{\link[=bmi]{bmi()}}
}
