% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accuracy_method.R
\name{accuracy}
\alias{accuracy}
\alias{accuracy.default}
\alias{accuracy.lvmisc_cv}
\alias{accuracy.lm}
\alias{accuracy.lmerMod}
\title{Model accuracy}
\usage{
accuracy(model, na.rm = FALSE)

\method{accuracy}{default}(model, na.rm = FALSE)

\method{accuracy}{lvmisc_cv}(model, na.rm = FALSE)

\method{accuracy}{lm}(model, na.rm = FALSE)

\method{accuracy}{lmerMod}(model, na.rm = FALSE)
}
\arguments{
\item{model}{An object of class \code{lvmisc_cv} or an object containing
a model.}

\item{na.rm}{A logical value indicating whether or not to strip \code{NA}
values to compute the indices. Defaults to \code{FALSE}.}
}
\value{
An object of class \code{lvmisc_accuracy}. See "Details" for more
information.
}
\description{
Computes some common model accuracy indices, such as the R squared, mean
absolute error, mean absolute percent error and root mean square error.
}
\details{
The method for the \code{lm} class (or for the \code{lvmisc_cv}
class of a \code{lm}) returns a data frame with the columns \code{AIC}
(Akaike information criterion), \code{BIC} (Bayesian information
criterion), \code{R2} (R squared), \code{R2_adj} (adjusted R squared),
\code{MAE} (mean absolute error), \code{MAPE} (mean absolute percent
error) and \code{RMSE} (root mean square error).

The method for the \code{lmerMod} (or for the \code{lvmisc_cv} class of a
\code{lmerMod}) returns a data frame with the columns \code{R2_marg} and
\code{R2_cond} instead of the columns \code{R2} and \code{R2_adj}.
All the other columns are the same as the method for \code{lm}.
\code{R2_marg} is the marginal R squared, which considers only the variance
by the fixed effects of a mixed model, and \code{R2_cond} is the
conditional R squared, which considers both fixed and random effects
variance.
}
\examples{
mtcars <- tibble::as_tibble(mtcars, rownames = "car")
m <- stats::lm(disp ~ mpg, mtcars)
cv <- loo_cv(m, mtcars, car, keep = "used")

accuracy(m)
accuracy(cv)
}
