% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bounding_circle.R
\name{bounding_circle}
\alias{bounding_circle}
\alias{st_minimum_bounding_circle}
\title{Generate the minimum bounding circle}
\usage{
st_minimum_bounding_circle(x, nQuadSegs = 30)
}
\arguments{
\item{x}{object of class \code{sfg}, \code{sfg} or \code{sf}}

\item{nQuadSegs}{number of segments per quadrant (passed to \code{st_buffer})}
}
\value{
Object of the same class as \code{x}
}
\description{
Generate the minimum bounding circle
}
\details{
\code{st_minimum_bounding_circle} uses the \code{lwgeom_calculate_mbc} method also used by the PostGIS command \code{ST_MinimumBoundingCircle}. It is only available if the package was linked against liblwgeom, which is currently not the case for the binary CRAN distributions; see the package source code repository for instructions how to install liblwgeom. The example below shows how to run-time check the availability of liblwgeom.
}
\examples{
library(sf)

x = st_multipoint(matrix(c(0,1,0,1),2,2))
y = st_multipoint(matrix(c(0,0,1,0,1,1),3,2))

mbcx = st_minimum_bounding_circle(x)
mbcy = st_minimum_bounding_circle(y)

if (.Platform$OS.type != "windows") {
  plot(mbcx, axes=TRUE); plot(x, add=TRUE)
  plot(mbcy, axes=TRUE); plot(y, add=TRUE)
}

nc = st_read(system.file("shape/nc.shp", package="sf"))
state = st_union(st_geometry(nc))

if (.Platform$OS.type != "windows") {
  plot(st_minimum_bounding_circle(state), asp=1)
  plot(state, add=TRUE)
}

}
