% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/routing_functions.R
\name{boundGrade}
\alias{boundGrade}
\title{Bound grades within a specified range}
\usage{
boundGrade(
  current_grade,
  grade_of_record,
  route_limit_below,
  route_limit_above
)
}
\arguments{
\item{current_grade}{the current grade. This must be formatted as \code{G?}, where \code{?} is a number.}

\item{grade_of_record}{the grade of record. This must be formatted as \code{G?}, where \code{?} is a number.}

\item{route_limit_below}{the number of grades to allow routing below, relative to the grade of record. If the grade of record is G4 and this is 1, then routing to G3 is allowed but not to G2.}

\item{route_limit_above}{the number of grades to allow routing above, relative to the grade of record. If the grade of record is G4 and this is 2, then routing to G6 is allowed but not to G7.}
}
\value{
the grade after the range limit is applied
}
\description{
\code{\link{boundGrade}} is a function for keeping the grade within a specified range.
\code{\link{boundGrade}} checks the relative grade compared to the grade of record. If the current grade is outside the allowed bound, the grade that is within the bound in the same direction is returned.
}
\examples{
boundGrade("G2", "G1", 0, 2) # G2
boundGrade("G3", "G1", 0, 2) # G3
boundGrade("G4", "G1", 0, 2) # G3
boundGrade("G5", "G1", 0, 2) # G3

}
