% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module_structure_operators.R
\name{createAssessmentStructure}
\alias{createAssessmentStructure}
\title{Create an assessment structure}
\usage{
createAssessmentStructure(
  n_test,
  n_phase,
  route_limit_below,
  route_limit_above,
  test_routing_restrictions = c("R1", "R2", "R3")
)
}
\arguments{
\item{n_test}{a numeric, the number of test administrations.}

\item{n_phase}{a numeric, the number of phases within each test.}

\item{route_limit_below}{the number of grades to allow routing below, relative to the grade of record. If the grade of record is G4 and this is 1, then routing to G3 is allowed but not to G2.}

\item{route_limit_above}{the number of grades to allow routing above, relative to the grade of record. If the grade of record is G4 and this is 2, then routing to G6 is allowed but not to G7.}

\item{test_routing_restrictions}{the restrictions for between-test routing. (default = \code{c("R1", "R2", "R3")})}
}
\value{
an \code{\linkS4class{assessment_structure}} object.
}
\description{
\code{\link{createAssessmentStructure}} is a function for creating an
\code{\linkS4class{assessment_structure}} object that defines the structure of the assessment.
}
\examples{
assessment_structure <- createAssessmentStructure(
  n_test  = 3,
  n_phase = 2,
  route_limit_below = 1,
  route_limit_above = 2
)

}
