% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mable.r
\name{bern.poly}
\alias{bern.poly}
\title{Bernstein polynomials}
\usage{
bern.poly(x, p, interval = c(0, 1), density = TRUE)
}
\arguments{
\item{x}{sequence of values in (a,b) at which density/distribution function to be evaluated}

\item{p}{mixing proportions. The \code{m+1} components of \code{p} must be nonnegative.}

\item{interval}{a vector containing the endpoints of supporting/truncation interval}

\item{density}{logical, whether a density or a distribution function to be calculated. Default is TRUE.}
}
\value{
A vector of \eqn{f_m(x; p)} or \eqn{F_m(x; p)} values at \eqn{x}
}
\description{
The Bernstein polynomials at \code{x} with coefficients \code{p} on an \code{interval}
}
\examples{
# classical Bernstein polynomial approximation
a<--4; b<-4; m<-200
x<-seq(a,b,len=512)
u<-(0:m)/m
p<-dnorm(a+(b-a)*u)
plot(x, dnorm(x), type="l")
lines(x, (b-a)*bern.poly(x, p, c(a, b))/(m+1), lty=2, col=2)
legend(a, dnorm(0), lty=1:2, col=1:2, c(expression(f(x)==phi(x)),
               expression(B^{f}*(x))))

}
\references{
Guan, Z. (2016) Efficient and robust density estimation using Bernstein type polynomials. \emph{Journal of Nonparametric Statistics}, 28(2):250-271.
Guan, Z. (2017) Bernstein polynomial model for grouped continuous data. \emph{Journal of Nonparametric Statistics}, 29(4):831-848.
}
\seealso{
\code{\link{mable}}
}
\author{
Zhong Guan <zguan@iusb.edu>
}
\concept{Bernstein polynomial model}
\keyword{distribution}
\keyword{models}
\keyword{nonparametric}
\keyword{smooth}
