% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_expand.R
\name{text_expand}
\alias{text_expand}
\title{Evaluate expressions in curly brackets inside strings}
\usage{
text_expand(..., delim = c("\\\\{", "\\\\}"))
}
\arguments{
\item{...}{character vectors}

\item{delim}{character vector of length 2 - pair of opening and closing
delimiters for the templating tags. By default it is curly brackets. Note
that \code{delim} will be used in the perl-style regular expression so you
need to escape special characters, e. g. use "\\\\\{" instead of
"\{".}
}
\value{
Vector of characters
}
\description{
\code{text_expand} is simple string interpolation function. It searches in its
arguments expressions in curly brackets \code{{expr}}, evaluate them and substitute with
the result of evaluation. See examples.
}
\examples{
i = 1:5
text_expand("q{i}")

i = 1:3
j = 1:3
text_expand("q1_{i}_{j}")

data(iris)
text_expand("'iris' has {nrow(iris)} rows.")
}
