% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PS.MA.r
\name{PS.MA}
\alias{PS.MA}
\title{Calculate model probabilities for the propensity score model using a pseudo-MC3 algorithm}
\usage{
PS.MA(X, U, W = NULL, M = 1000, alpha = NULL, master.index = NULL,
  master.dict = list())
}
\arguments{
\item{X}{vector of the treatment (0/1)}

\item{U}{matrix of covariates to be considered for inclusion/exclusion}

\item{W}{matrix of covariates that will be included in all models (optional)}

\item{M}{the number of MCMC iteration}

\item{alpha}{vector of inclusion indicators (which columns of U) to start MCMC algorithm (optional)}

\item{master.index}{indexes which columns of U should be considered for inclusion in the propensity score model (optional)}

\item{master.dict}{list containing information from previous propensity score model fits (optional)}
}
\value{
A list. The list contains the following named components:
\item{dict}{a list that contains the BIC and estimated propensity scores from propensity score models}
\item{alpha}{the last model visited by the algorithm}
\item{out.table}{a matrix that contains the BIC from each propensity score model}
}
\description{
This function uses a pseudo-MC3 algorithm to search the propensity score model space.
}

