% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtools.R
\name{rtools}
\alias{rtools}
\alias{rtools_find}
\alias{rtools_registry_info}
\alias{rtools_install}
\title{Find or Install Rtools}
\usage{
rtools_find()

rtools_registry_info()

rtools_install(silent = TRUE)
}
\arguments{
\item{silent}{performs automatic unattended installation with all
the default options. If set to \code{FALSE} the user has to click through
the usual installation wizard.}
}
\description{
Tools to test if a suitable version of Rtools is available, or help
the user to set this up.
}
\details{
Unlike most operating systems, Windows does not include a native compiler.
Hence in order to build R packages with compiled C/C++/Fortran code on
Windows, you need to install our custom toolchain bundle called Rtools.

There are currently 2 versions of Rtools available:
\itemize{
\item \href{https://cran.r-project.org/bin/windows/Rtools/}{rtools40}: required
for compiling packages on R-4.0 and newer
\item \href{https://cran.r-project.org/bin/windows/Rtools/history.html}{rtools35}:
required for compiling packages on R-3.6 and older
}

The function \link{rtools_find} shows information about a suitable version of
Rtools installed on your system. If needed, it automatically adds \code{make}
to the PATH of the current session. If \code{rtools_find()} returns a list
(containing toolchain information), this means everything is ready to
install packages from source using \link{install.packages} and others. It
returns \code{NULL} if no suitable version is found on the system.

The \link{rtools_install} function automatically downloads and installs the
appropriate version of Rtools for your current version of R.
}
\seealso{
Other maketools: 
\code{\link{diagnostics}},
\code{\link{make}()},
\code{\link{pkgconfig}},
\code{\link{r_config}},
\code{\link{sysdeps}}
}
\concept{maketools}
