% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pedigree_haplotype_matches_in_pedigree_meiosis_L1_dists}
\alias{pedigree_haplotype_matches_in_pedigree_meiosis_L1_dists}
\title{Information about matching individuals}
\usage{
pedigree_haplotype_matches_in_pedigree_meiosis_L1_dists(
  suspect,
  generation_upper_bound_in_result = -1L,
  error_on_no_haplotype = TRUE
)
}
\arguments{
\item{suspect}{Individual that others must match the profile of.}

\item{generation_upper_bound_in_result}{Only consider matches in
generation 0, 1, ... generation_upper_bound_in_result.
-1 means disabled, consider all generations.
End generation is generation 0.
Second last generation is 1.
And so on.}

\item{error_on_no_haplotype}{raise error or silently ignore individuals
with no haplotype}
}
\value{
Matrix with information about matching individuals.
Columns in order: meioses (meiotic distance to \code{suspect}),
max_L1 (on the path between the matching individual and \code{suspect},
what is the maximum L1 distance between the \code{suspect}'s profile and the
profiles of the individuals on the path),
pid (pid of matching individual)
}
\description{
Gives information about all individuals in pedigree that matches an individual.
Just as \code{\link[=count_haplotype_occurrences_individuals]{count_haplotype_occurrences_individuals()}} counts the number of
occurrences amongst a list of individuals,
this gives detailed information about matching individuals in the pedigree,
e.g. meiotic distances and maximum L1 distance on the path as some of these
matches may have (back)mutations between in between them (but often this will be 0).
}
\seealso{
\code{\link[=count_haplotype_occurrences_individuals]{count_haplotype_occurrences_individuals()}}.
}
