% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_many_biotyper_reports.R
\name{read_many_biotyper_reports}
\alias{read_many_biotyper_reports}
\title{Importing a list of Bruker MALDI Biotyper CSV reports}
\usage{
read_many_biotyper_reports(path_to_reports, report_ids, best_hits = TRUE, ...)
}
\arguments{
\item{path_to_reports}{A vector of paths to the csv files to be imported by \code{\link[=read_biotyper_report]{read_biotyper_report()}}.}

\item{report_ids}{A vector of character names for each of the reports.}

\item{best_hits}{A logical indicating whether to return only the best hit in the \code{\link[=read_biotyper_report]{read_biotyper_report()}} function.}

\item{...}{Name-value pairs to be passed on to \code{\link[dplyr:mutate]{dplyr::mutate()}}}
}
\value{
A tibble just like the one returned by the \code{\link[=read_biotyper_report]{read_biotyper_report()}} function, except that the name of the spot of the MALDI target (i.e., plate) is registered to the \code{original_name} column (instead of the \code{name} column), and the column \code{name} consist in the provided \code{report_ids} used as a prefix of the \code{original_name} column.
}
\description{
Importing a list of Bruker MALDI Biotyper CSV reports
}
\note{
The report identifiers are sanitized to convert all dashes (\code{-}) as underscores (\verb{_}).
}
\examples{
# List of Bruker MALDI Biotyper reports
reports_paths <- system.file(
  c("biotyper.csv", "biotyper.csv", "biotyper.csv"),
  package = "maldipickr"
)
# Read the list of reports and combine them in a single tibble
read_many_biotyper_reports(
  reports_paths,
  report_ids = c("first", "second", "third"),
  # Additional metadata below are passed to dplyr::mutate
  growth_temperature = 37.0
)
}
\seealso{
\link{read_biotyper_report}
}
