/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util.tests;

import cc.mallet.types.MatrixOps;
import cc.mallet.util.Maths;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestMaths
extends TestCase {
    public TestMaths(String name) {
        super(name);
    }

    public void testLogBinom() {
        TestMaths.assertEquals((double)-3.207352, (double)Maths.logBinom(25, 50, 0.4), (double)1.0E-5);
        TestMaths.assertEquals((double)-230.2585, (double)Maths.logBinom(0, 100, 0.9), (double)1.0E-5);
    }

    public void testPbinom() {
        TestMaths.assertEquals((double)0.9426562, (double)Maths.pbinom(25, 50, 0.4), (double)1.0E-5);
        TestMaths.assertEquals((double)0.001978561, (double)Maths.pbinom(80, 100, 0.9), (double)1.0E-5);
    }

    public void testSumLogProb() {
        double[] vals = new double[]{53.0, 15600.0, 0.0045, 672.563, 1.0E-15};
        double[] logVals = new double[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            logVals[i] = Math.log(vals[i]);
        }
        double sum = MatrixOps.sum(vals);
        double lsum2 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < logVals.length; ++i) {
            lsum2 = Maths.sumLogProb(lsum2, logVals[i]);
        }
        TestMaths.assertEquals((double)sum, (double)Math.exp(lsum2), (double)1.0E-5);
        double lsum = Maths.sumLogProb(logVals);
        TestMaths.assertEquals((double)sum, (double)Math.exp(lsum), (double)1.0E-5);
    }

    public void testSubtractLogProb() {
        double a = 0.9;
        double b = 0.25;
        TestMaths.assertEquals((double)Math.log(a - b), (double)Maths.subtractLogProb(Math.log(a), Math.log(b)), (double)1.0E-5);
        TestMaths.assertTrue((boolean)Double.isNaN(Maths.subtractLogProb(Math.log(b), Math.log(a))));
    }

    public static Test suite() {
        return new TestSuite(TestMaths.class);
    }

    public static void main(String[] args) throws Throwable {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest((Test)new TestMaths(args[i]));
            }
        } else {
            theSuite = (TestSuite)TestMaths.suite();
        }
        TestRunner.run((Test)theSuite);
    }
}

