% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call_treaties.R
\name{call_treaties}
\alias{call_treaties}
\title{Call treaties from 'many' datasets}
\usage{
call_treaties(
  dataset,
  treaty_type = NULL,
  variable = NULL,
  actor = NULL,
  key = "manyID"
)
}
\arguments{
\item{dataset}{A dataset in a datacube from one of the many packages.
NULL by default.
That is, all datasets in the datacube are used.
For multiple datasets, please declare datasets as a vector
(e.g. c("dataset1", "dataset2")).}

\item{treaty_type}{The type of treaties to be returned.
NULL, by default.
Other options are "bilateral" or "multilateral".}

\item{variable}{Would you like to get one, or more, specific variables
present in one or more datasets in the 'many' datacube?
NULL by default.
For multiple variables, please declare variable names as a vector.}

\item{actor}{An actor variable in dataset.
NULL by default.
If declared, a tibble of the treaties and their member actors is returned.}

\item{key}{A variable key to join datasets.
'manyID' by default.}
}
\value{
\code{call_treaties()} returns a tibble with a list of the agreements.
}
\description{
Call treaties from 'many' datasets
}
\details{
Certain datasets, or consolidated datacubes, in 'many' packages
contains information on treaties which can be retrieved
with \code{call_treaties()}.
}
\examples{
\donttest{
membs <- dplyr::tibble(manyID = c("ROU-RUS[RFP]_1901A",
"ROU-RUS[RFP]_1901A", "GD16FI_1901A"),
stateID = c("ROU", "RUS", "DNK"),
Title = c("Convention Between Roumania And Russia Concerning Fishing
In The Danube And The Pruth",
"Convention Between Roumania And Russia Concerning Fishing
In The Danube And The Pruth",
"Convention Between The Governments Of Denmark And
The United Kingdom Of Great Britain
And Northern Ireland For Regulating The Fisheries
Of Their Respective Subjects Outside
Territorial Waters In The Ocean Surrounding The Faroe Islands"),
Begin = c("1901-02-22", "1901-02-22", "1901-06-24"))
call_treaties(membs)
call_treaties(membs, treaty_type = "bilateral",
variable = c("Title", "Begin"))
call_treaties(membs, variable = c("Title", "Begin"), actor = "stateID")
}
}
\seealso{
Other call_: 
\code{\link{call_packages}()},
\code{\link{call_releases}()}
}
\concept{call_}
