% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dat_2_and_3.R
\docType{data}
\name{data_med}
\alias{data_med}
\title{Sample Dataset: Simple
Mediation}
\format{
A data frame with 100 rows
and 5 variables:
\describe{
\item{x}{Predictor. Numeric.}
\item{m}{Mediator. Numeric.}
\item{y}{Outcome variable. Numeric.}
\item{c1}{Control variable. Numeric.}
\item{c2}{Control variable. Numeric.}
}
}
\usage{
data_med
}
\description{
A simple mediation
model.
}
\examples{
library(lavaan)
data(data_med)
mod <-
"
m ~ a * x + c1 + c2
y ~ b * m + x + c1 + c2
ab := a * b
"
fit <- sem(mod, data_med, fixed.x = FALSE)
parameterEstimates(fit)
}
\keyword{datasets}
