% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lgpa.R
\name{lgpa}
\alias{lgpa}
\title{Large-scale Generalized Procrustes Analysis}
\usage{
lgpa(x, sub.id = 1:(dim(x)[1]), scale = TRUE, reflect = FALSE)
}
\arguments{
\item{x}{a \eqn{(k\times m\times n)} 3d array, where \eqn{k} is the number of points, \eqn{m} the number of dimensions, and \eqn{n} the number of samples.}

\item{sub.id}{a vector of indices for defining anchor points.}

\item{scale}{a logical; \code{TRUE} if scaling is applied, \code{FALSE} otherwise.}

\item{reflect}{a logical; \code{TRUE} if reflection is required, \code{FALSE} otherwise.}
}
\value{
a \eqn{(k\times m\times n)} 3d array of aligned samples.
}
\description{
We modify generalized Procrustes analysis for large-scale data by 
first setting a subset of anchor points and applying the attained transformation 
to the rest data. If \code{sub.id} is a vector \code{1:dim(x)[1]}, it uses all 
observations as anchor points, reducing to the conventional generalized Procrustes analysis.
}
\examples{
\dontrun{
## This should be run if you have 'shapes' package installed.
library(shapes)
data(gorf.dat)

## apply anchor-based method and original procGPA
out.proc = shapes::procGPA(gorf.dat, scale=TRUE)$rotated # procGPA from shapes package
out.anc4 = lgpa(gorf.dat, sub.id=c(1,4,9,7), scale=TRUE) # use 4 points 
out.anc7 = lgpa(gorf.dat, sub.id=1:7, scale=TRUE)        # use all but 1 point as anchors

## visualize
opar = par(mfrow=c(3,4), pty="s")
plot(out.proc[,,1], main="procGPA No.1", pch=18)
plot(out.proc[,,2], main="procGPA No.2", pch=18)
plot(out.proc[,,3], main="procGPA No.3", pch=18)
plot(out.proc[,,4], main="procGPA No.4", pch=18)
plot(out.anc4[,,1], main="4 Anchors No.1", pch=18, col="blue")
plot(out.anc4[,,2], main="4 Anchors No.2", pch=18, col="blue")
plot(out.anc4[,,3], main="4 Anchors No.3", pch=18, col="blue")
plot(out.anc4[,,4], main="4 Anchors No.4", pch=18, col="blue")
plot(out.anc7[,,1], main="7 Anchors No.1", pch=18, col="red")
plot(out.anc7[,,2], main="7 Anchors No.2", pch=18, col="red")
plot(out.anc7[,,3], main="7 Anchors No.3", pch=18, col="red")
plot(out.anc7[,,4], main="7 Anchors No.4", pch=18, col="red")
par(opar)
}

}
\references{
\insertRef{goodall_procrustes_1991}{maotai}
}
\author{
Kisung You
}
