% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_get_gridmap.R
\name{esp_get_hex_prov}
\alias{esp_get_hex_prov}
\alias{esp_get_hex_ccaa}
\alias{esp_get_grid_prov}
\alias{esp_get_grid_ccaa}
\title{Get an hexbin or a map of squares of Spain}
\usage{
esp_get_hex_prov(prov = NULL)

esp_get_hex_ccaa(ccaa = NULL)

esp_get_grid_prov(prov = NULL)

esp_get_grid_ccaa(ccaa = NULL)
}
\arguments{
\item{prov}{A vector of names and/or codes for provinces
or \code{NULL} to get all the provinces. See Details.}

\item{ccaa}{A vector of names and/or codes for autonomous communities
or \code{NULL} to get all the autonomous communities. See Details.}
}
\value{
A \code{POLYGON} object.
}
\description{
Loads a hexbin map (\code{sf} object) or a map of squares with the boundaries of
the provinces or autonomous communities of Spain.
}
\details{
Hexbin or grid map has an advantage over usual choropleth maps.
In choropleths, a large polygon data looks more emphasized just because
of its size, what introduces a bias. Here with hexbin, each region is
represented equally dismissing the bias.

Results are provided in \strong{EPSG:4258}, use \code{\link[sf:st_transform]{sf::st_transform()}}
to change the projection.

See  \code{\link[=esp_get_ccaa]{esp_get_ccaa()}}, \code{\link[=esp_get_prov]{esp_get_prov()}} for Details.
}
\examples{
library(tmap)

esp <- esp_get_country()
hexccaa <- esp_get_hex_ccaa()


tm_shape(esp, bbox = c(-13.5, 32, 7, 45)) +
  tm_polygons() +
  tm_shape(hexccaa) +
  tm_polygons("codauto", alpha = 0.6, legend.show = FALSE) +
  tm_shape(hexccaa) +
  tm_text("label")



hexprov <- esp_get_hex_prov()

tm_shape(esp, bbox = c(-13.5, 32, 7, 45)) +
  tm_polygons() +
  tm_shape(hexprov) +
  tm_polygons("cpro", alpha = 0.6, legend.show = FALSE) +
  tm_shape(hexprov) +
  tm_text("label")



gridccaa <- esp_get_grid_ccaa()

tm_shape(esp, bbox = c(-13.5, 32, 7, 45)) +
  tm_polygons() +
  tm_shape(gridccaa) +
  tm_polygons("codauto", alpha = 0.6, legend.show = FALSE) +
  tm_shape(gridccaa) +
  tm_text("label")

gridprov <- esp_get_grid_prov()

tm_shape(esp, bbox = c(-13.5, 32, 7, 45)) +
  tm_polygons() +
  tm_shape(gridprov) +
  tm_polygons("cpro", alpha = 0.6, legend.show = FALSE) +
  tm_shape(gridprov) +
  tm_text("label")
}
\seealso{
\code{\link[=esp_get_nuts]{esp_get_nuts()}}, \code{\link[=esp_get_ccaa]{esp_get_ccaa()}}, \code{\link[=esp_get_prov]{esp_get_prov()}}, \code{\link[=esp_get_munic]{esp_get_munic()}},
\code{\link{esp_codelist}}
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
\concept{political}
