% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_get_hypsobath.R
\name{esp_get_hypsobath}
\alias{esp_get_hypsobath}
\title{Get \code{sf} polygons and lines with the hypsometry and bathymetry of Spain}
\source{
IGN data via a custom CDN (see
\url{https://github.com/rOpenSpain/mapSpain/tree/sianedata}).
}
\usage{
esp_get_hypsobath(
  epsg = "4258",
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  resolution = "3",
  spatialtype = "area"
)
}
\arguments{
\item{epsg}{projection of the map: 4-digit \href{https://epsg.io/}{EPSG code}.
One of:
\itemize{
\item \code{"4258"}: ETRS89
\item \code{"4326"}: WGS84
\item \code{"3035"}: ETRS89 / ETRS-LAEA
\item \code{"3857"}: Pseudo-Mercator
}}

\item{cache}{A logical whether to do caching. Default is \code{TRUE}. See
\strong{About caching}.}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source file.}

\item{cache_dir}{A path to a cache directory. See \strong{About caching}.}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}

\item{resolution}{Resolution of the shape. Values available
are \code{"3"} or \code{"6.5"}.}

\item{spatialtype}{Spatial type of the output. Use \code{"area"} for polygons or
\code{"line"} for lines.}
}
\value{
A \code{sf} polygon or line object.
}
\description{
Loads a \code{sf} polygon or line object representing the hypsometry and
bathymetry of Spain.
\itemize{
\item \strong{Hypsometry} represents the  the elevation and depth of features of the
Earth's surface relative to mean sea level.
\item \strong{Bathymetry} is the measurement of the depth of water in oceans, rivers,
or lakes.
}
}
\details{
Metadata available on
\url{https://github.com/rOpenSpain/mapSpain/tree/sianedata/}.
}
\section{About caching}{
You can set your \code{cache_dir} with \code{\link[=esp_set_cache_dir]{esp_set_cache_dir()}}.

Sometimes cached files may be corrupt. On that case, try re-downloading
the data setting \code{update_cache = TRUE}.

If you experience any problem on download, try to download the
corresponding .geojson file by any other method and save it on your
\code{cache_dir}. Use the option \code{verbose = TRUE} for debugging the API query.
}

\examples{
\donttest{
# This code would produce a nice plot - It will take a few seconds to run
library(tmap)

hypsobath <- esp_get_hypsobath()

# Tints from Wikipedia
# https://en.wikipedia.org/wiki/Wikipedia:WikiProject_Maps/Conventions/Topographic_maps

bath_tints <- colorRampPalette(
  rev(
    c(
      "#D8F2FE", "#C6ECFF", "#B9E3FF",
      "#ACDBFB", "#A1D2F7", "#96C9F0",
      "#8DC1EA", "#84B9E3", "#79B2DE",
      "#71ABD8"
    )
  )
)

hyps_tints <- colorRampPalette(
  rev(
    c(
      "#F5F4F2", "#E0DED8", "#CAC3B8", "#BAAE9A",
      "#AC9A7C", "#AA8753", "#B9985A", "#C3A76B",
      "#CAB982", "#D3CA9D", "#DED6A3", "#E8E1B6",
      "#EFEBC0", "#E1E4B5", "#D1D7AB", "#BDCC96",
      "#A8C68F", "#94BF8B", "#ACD0A5"
    )
  )
)

levels <- sort(unique(hypsobath$val_inf))

# Create palette
br_bath <- length(levels[levels < 0])
br_terrain <- length(levels) - br_bath

bath_tints(br_bath)

pal <- c(bath_tints((br_bath)), hyps_tints((br_terrain)))


# Plot Canary Islands
tm_shape(hypsobath, bbox = c(-18.6, 27, -13, 29.5)) +
  tm_fill("val_inf",
    style = "cat",
    palette = pal,
    title = "Elevation",
    legend.reverse = TRUE
  ) +
  tm_layout(
    legend.outside = TRUE
  )


# Plot Mainland
tm_shape(hypsobath, bbox = c(-9.5, 35.8, 4.4, 44)) +
  tm_fill("val_inf",
    style = "cat",
    palette = pal,
    title = "Elevation",
    legend.reverse = TRUE
  ) +
  tm_layout(legend.outside = TRUE)
}
}
\seealso{
Other natural: 
\code{\link{esp_get_hydrobasin}()},
\code{\link{esp_get_rivers}()}
}
\concept{natural}
