% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapbayest_check_and_preprocess.R
\name{preprocess.ofv}
\alias{preprocess.ofv}
\alias{preprocess.ofv.fix}
\alias{preprocess.ofv.id}
\title{Preprocess model and data for ofv computation}
\usage{
preprocess.ofv.fix(x, data, select_eta = seq_along(eta(x)), lambda = 1)

preprocess.ofv.id(x, iddata)
}
\arguments{
\item{x}{the model object}

\item{data, iddata}{NMTRAN-like data set. iddata is likely a dataset of one individual}

\item{select_eta}{numbers of the ETAs taken into account. Set the dimensions of the inversed OMEGA matrix}

\item{lambda}{a numeric value, the weight applied to the model prior (default is 1)}
}
\value{
A list of arguments used to compute the objective function value.

The following arguments are fixed between individuals:
\itemize{
\item \code{qmod}: model object, modified to simulate without random effects and with controlled outputs
\item \code{sigma}: a single matrix object
\item \code{log_transformation}: a logical, whether predictions need to be log-transformed for ofv computation
\item \code{omega_inv}: a single matrix object
\item \code{all_cmt}: a vector of compartment numbers where observations can be expected
}

The following arguments differs between individuals:
\itemize{
\item \code{idvaliddata}: a matrix, individual data set (with administrations and covariates), validated with \code{\link[mrgsolve]{valid_data_set}}
\item \code{idDV}: a vector of (possibly log-transformed) observations
\item \code{idcmt}: a vector of compartments where observations belong to
\item \code{idblq},\code{idlloq}: optional, a logical and numerical vector indicating if the observation is below the lower limit of quantification, and the LLOQ value, respectively
}
}
\description{
Functions to generate arguments passed to \code{\link{compute_ofv}}. Arguments that are fixed between individuals are created once (\code{preprocess.ofv.fix}), while others are specific of each individual (\code{preprocess.ofv.id}).
}
\examples{
mod <- exmodel(add_exdata = FALSE, compile = FALSE)
dat <- exdata(ID = c(1,4))

preprocess.ofv.fix(x = mod, data = dat)
preprocess.ofv.id(x = mod, iddata = dat[dat$ID == 1,])
preprocess.ofv.id(x = mod, iddata = dat[dat$ID == 4,])

}
