% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terrain.R
\name{set_fog}
\alias{set_fog}
\title{Set fog on a Mapbox GL map}
\usage{
set_fog(
  map,
  range = NULL,
  color = NULL,
  horizon_blend = NULL,
  high_color = NULL,
  space_color = NULL,
  star_intensity = NULL
)
}
\arguments{
\item{map}{A map object created by the \code{mapboxgl} function or a proxy object.}

\item{range}{A numeric vector of length 2 defining the minimum and maximum range of the fog.}

\item{color}{A string specifying the color of the fog.}

\item{horizon_blend}{A number between 0 and 1 controlling the blending of the fog at the horizon.}

\item{high_color}{A string specifying the color of the fog at higher elevations.}

\item{space_color}{A string specifying the color of the fog in space.}

\item{star_intensity}{A number between 0 and 1 controlling the intensity of the stars in the fog.}
}
\value{
The updated map object.
}
\description{
Set fog on a Mapbox GL map
}
