% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_population_count.R
\docType{data}
\name{population_count}
\alias{population_count}
\title{Calculate population count statistics}
\format{
A tibble with a column for population count statistics
}
\description{
WorldPop, which was initiated in 2013, offers easy access to spatial demographic
datasets, claiming to use peer-reviewed and fully transparent methods to create
global mosaics for the years 2000 to 2020. This function allows to efficiently
calculate population count statistics (e.g. total number of population) for
polygons. For each polygon, the desired statistic/s (min, max, sum, mean,
median, sd or var) is/are returned.
The required resources for this indicator are:
\itemize{
\item \link{worldpop}
}
}
\details{
The following arguments can be set:
\describe{
\item{stats_popcount}{Function to be applied to compute statistics for polygons either
one or multiple inputs as character. Supported statistics are: "mean",
"median", "sd", "min", "max", "sum" "var".}
\item{engine}{The preferred processing functions from either one of "zonal",
"extract" or "exactextract" as character.}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  init_portfolio(
    years = 2000:2010,
    outdir = outdir,
    tmpdir = tempdir(),
    add_resources = FALSE,
    verbose = FALSE
  ) \%>\%
  get_resources("worldpop") \%>\%
  calc_indicators("population_count", stats_popcount = c("sum", "median"), engine = "extract") \%>\%
  tidyr::unnest(population_count)

aoi
}
}
\keyword{indicator}
