% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_mappoly_prob.R
\name{read_geno_prob}
\alias{read_geno_prob}
\title{Data Input}
\usage{
read_geno_prob(
  file.in,
  prob.thres = 0.95,
  filter.non.conforming = TRUE,
  elim.redundant = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{file.in}{a character string with the name of (or full path to) the input file which contains the data to
be read}

\item{prob.thres}{probability threshold to associate a marker call to a 
dosage. Markers with maximum genotype probability smaller than \code{prob.thres} 
are considered as missing data for the dosage calling purposes (default = 0.95)}

\item{filter.non.conforming}{if \code{TRUE} (default) converts data points with unexpected 
genotypes (i.e. no double reduction) to 'NA'. See function \code{\link[mappoly]{segreg_poly}} 
for information on expected classes and their respective frequencies.}

\item{elim.redundant}{logical. If \code{TRUE} (default), removes redundant markers
during map construction, keeping them annotated to export to the final map.}

\item{verbose}{if \code{TRUE} (default), the current progress is shown; if
\code{FALSE}, no output is produced}
}
\value{
an object of class \code{mappoly.data} which contains a
    list with the following components:
    \item{m}{ploidy level}
    \item{n.ind}{number individuals}
    \item{n.mrk}{total number of markers}
    \item{ind.names}{the names of the individuals}
    \item{mrk.names}{the names of the markers}
    \item{dosage.p}{a vector containing the dosage in
      parent P for all \code{n.mrk} markers}
    \item{dosage.q}{a vector containing the dosage in
      parent Q for all \code{n.mrk} markers}
    \item{sequence}{a vector indicating which sequence each marker
      belongs. Zero indicates that the marker was not assigned to any
      sequence}
    \item{sequence.pos}{physical position of the markers into the
      sequence}
    \item{seq.ref}{NULL (unused in this type of data)}
    \item{seq.alt}{NULL (unused in this type of data)}
    \item{all.mrk.depth}{NULL (unused in this type of data)}
    \item{prob.thres}{probability threshold to associate a marker call to a 
    dosage. Markers with maximum genotype probability smaller than 'prob.thres' 
    were considered as missing data in the 'geno.dose' matrix}
    \item{geno.dose}{a matrix containing the dosage for each markers (rows) 
      for each individual (columns). Missing data are represented by 
      \code{ploidy_level + 1}}
    \item{geno}{a data.frame 
      containing the probability distribution for each combination of
      marker and offspring. The first two columns represent the marker
      and the offspring, respectively. The remaining elements represent
      the probability associated to each one of the possible
      dosages. Missing data are converted from NA to the expected
      segregation ratio using function \code{\link[mappoly]{segreg_poly}}}
    \item{n.phen}{number of phenotypic traits}
    \item{phen}{a matrix containing the phenotypic data. The rows
                correspond to the traits and the columns correspond
                to the individuals}
    \item{chisq.pval}{a vector containing p-values related to the chi-squared 
    test of Mendelian segregation performed for all markers}
    \item{kept}{if elim.redundant=TRUE, holds all non-redundant markers}
    \item{elim.correspondence}{if elim.redundant=TRUE, holds all non-redundant markers and
its equivalence to the redundant ones}
}
\description{
Reads an external data file. The format of the file is described in the \code{Details}
section. This function creates an object of class \code{mappoly.data}
}
\details{
The first line of the input file contains the string \code{ploidy} followed by the ploidy level of the parents.
The second and third lines contains the strings \code{nind} and \code{nmrk} followed by the number of individuals in 
the dataset and the total number of markers, respectively. Lines number 4 and 5 contain the string 
\code{mrknames} and \code{indnames} followed by a sequence of the names of the markers and the name of the individuals, 
respectively. Lines 6 and 7 contain the strings \code{dosageP} and \code{dosageQ} followed by a sequence of numbers 
containing the dosage of all markers in parent \code{P} and \code{Q}. Line 8, contains the string seq followed by 
a sequence of integer numbers indicating the sequence each marker belongs. It can be any 'a priori' 
information regarding the physical distance between markers. For example, these numbers could refer 
to chromosomes, scaffolds or even contigs, in which the markers are positioned. If this information 
is not available for a particular marker, NA should be used. If this information is not available for 
any of the markers, the string \code{seq} should be followed by a single \code{NA}. Line number 9 contains the string 
\code{seqpos} followed by the physical position of the markers into the sequence. The physical position can be 
given in any unity of physical genomic distance (base pairs, for instance). However, the user should be 
able to make decisions based on these values, such as the occurrence of crossing overs, etc. Line number 10 
should contain the string \code{nphen} followed by the number of phenotypic traits. Line number 11 is skipped 
(Usually used as a spacer). The next elements are strings containing the name of the phenotypic trait with no space characters
followed by the phenotypic values. The number of lines should be the same number of phenotypic traits. 
\code{NA} represents missing values. The line number 12 + \code{nphen} is skipped. Finally, the last element is a table 
containing the probability distribution for each combination of marker and offspring. The first two columns 
represent the marker and the offspring, respectively. The remaining elements represent the probability 
associated with each one of the possible dosages. \code{NA} represents missing data.
}
\examples{
\donttest{
#### Tetraploid Example
ft="https://raw.githubusercontent.com/mmollina/MAPpoly_vignettes/master/data/hexa_sample"
tempfl <- tempfile()
download.file(ft, destfile = tempfl)
SolCAP.dose.prob <- read_geno_prob(file.in  = tempfl)
print(SolCAP.dose.prob, detailed = TRUE)
plot(SolCAP.dose.prob)
}

}
\references{
Mollinari M., Olukolu B. A.,  Pereira G. da S., 
    Khan A., Gemenet D., Yencho G. C., Zeng Z-B. (2020), 
    Unraveling the Hexaploid Sweetpotato Inheritance 
    Using Ultra-Dense Multilocus Mapping, 
    _G3: Genes, Genomes, Genetics_. 
    \url{https://doi.org/10.1534/g3.119.400620} 
    
    Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \url{https://doi.org/10.1534/g3.119.400378}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
