% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_missing}
\alias{filter_missing}
\title{Filter missing genotypes}
\usage{
filter_missing(
  input.data,
  type = c("marker", "individual"),
  filter.thres = 0.2,
  inter = TRUE
)
}
\arguments{
\item{input.data}{an object of class \code{mappoly.data}}

\item{type}{one of the following options: 
\code{'marker'}{filter out markers based on their percentage of missing data (default)}
\code{'individual'}{filter out individuals based on their percentage of missing data}
Please notice that removing individuals with certain amount of data can change some marker parameters
(such as depth), and can also change the estimated genotypes for other individuals.
So be careful when removing individuals.}

\item{filter.thres}{maximum percentage of missing data (default = 0.2)}

\item{inter}{if \code{TRUE} (default), it plots markers or individuals vs. frequency of missing data}
}
\description{
Excludes markers or individuals based on their proportion of missing data
}
\examples{
plot(tetra.solcap)
dat.filt.mrk <- filter_missing(input.data = tetra.solcap,
                               type = "marker", 
                               filter.thres = 0.1,
                               inter = TRUE)
plot(dat.filt.mrk)
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
