% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_plot.R
\name{map_plot}
\alias{map_plot}
\title{Base R mapping}
\usage{
map_plot(x, lon = "longitude", lat = "latitude", color = NULL, size = 1,
  pch = 16, hull = FALSE, ...)
}
\arguments{
\item{x}{The data. An object of class \code{occdat}, \code{occdatind},
\code{gbif}, \code{gbif_data}, \code{SpatialPoints}, 
\code{SpatialPointsDataFrame}, or \code{data.frame}. The package 
\pkg{spocc} needed for
the first two, and \pkg{rgbif} needed for the third. When \code{data.frame}
input, any number of columns allowed, but with at least the following:
name (the taxonomic name), latitude (in dec. deg.), longitude (in dec. deg.)}

\item{lon, lat}{(character) Longitude and latitude variable names. Ignored
unless \code{data.frame} input to \code{x} parameter. We attempt to guess, 
but if nothing close, we stop. Default: \code{longitude} and 
\code{latitude}}

\item{color}{Default color of your points.}

\item{size}{point size, Default: 1}

\item{pch}{point symbol shape, Default: 16}

\item{hull}{(logical) whether to add a convex hull. Default: \code{FALSE}}

\item{...}{Further args to \code{\link[graphics:points]{graphics::points()}}}
}
\value{
Plots a world scale map
}
\description{
Base R mapping
}
\examples{
# map spocc output, here using a built in object
data(occdat_eg1)
map_plot(occdat_eg1)

# map rgbif output, here using a built in object
data(gbif_eg1)
map_plot(gbif_eg1)

\dontrun{
## spocc
library("spocc")
(out <- occ(query='Accipiter striatus', from='gbif', limit=25,
  has_coords=TRUE))
### class occdat
map_plot(out)
map_plot(out, hull = TRUE)
### class occdatind
map_plot(out$gbif)
map_plot(out$gbif, hull = TRUE)

## rgbif
library("rgbif")
### occ_search() output
res <- occ_search(scientificName = "Puma concolor", limit = 100)
map_plot(res)
map_plot(res, hull = TRUE)

### occ_data() output
res <- occ_data(scientificName = "Puma concolor", limit = 100)
map_plot(res)
#### many taxa
res <- occ_data(scientificName = c("Puma concolor", "Quercus lobata"), 
   limit = 30)
res
map_plot(res)


## data.frame
df <- data.frame(
  name = c('Poa annua', 'Puma concolor', 'Foo bar', 'Stuff things'),
  longitude = c(-125, -123, -121, -110),
  latitude = c(41, 42, 45, 30), stringsAsFactors = FALSE)
map_plot(df)
map_plot(df, hull = TRUE)

### usage of occ2sp()
#### SpatialPoints
spdat <- occ2sp(out)
map_plot(spdat)
map_plot(spdat, hull = TRUE)

#### SpatialPointsDataFrame
spdatdf <- as(spdat, "SpatialPointsDataFrame")
map_plot(spdatdf)
map_plot(spdatdf, hull = TRUE)

# many species, each gets a different color
library("spocc")
spp <- c('Danaus plexippus', 'Accipiter striatus', 'Pinus contorta',
  'Ursus americanus')
dat <- occ(spp, from = 'gbif', limit = 30, has_coords = TRUE,
  gbifopts = list(country = 'US'))
map_plot(dat)
map_plot(dat, hull = TRUE)
## diff. color for each taxon
map_plot(dat, color = c('#976AAE', '#6B944D', '#BD5945', 'red'))
map_plot(dat, color = c('#976AAE', '#6B944D', '#BD5945', 'red'), hull = TRUE)

# add a convex hull
library("rgbif")
res <- occ_search(scientificName = "Puma concolor", limit = 100)
map_plot(res, hull = FALSE)
map_plot(res, hull = TRUE)
}
}
