\name{write.polylistShape}
\alias{write.polylistShape}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Write a polygon-type shapefile}
\description{
  The function calls code from shapelib to write a polygon-type shapefile from an S3 polylist object.
}
\usage{
write.polylistShape(polylist, df, file, factor2char = TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{polylist}{list of polygons of class \code{polylist}}
  \item{df}{a data frame object}
  \item{file}{a file name of maximum 8 chararacters, numbers or the underscore symbol to be written, omitting the extensions *.shp, *.shx and *.dbf, which are added in the function}
  \item{factor2char}{logical, default TRUE, convert factor columns to character}
}
\details{
  The function calls code from shapelib to write a point-type shapefile (both the geometry file with a *.shp extension, the index file with a *.shx extension, and the database file with a *.dbf extension - see \code{\link{dbf.write}} for details of the data frame export within this function.
}
\value{
  no return value.
}
\references{\url{http://shapelib.maptools.org/}}

\author{Nicholas J. Lewin-Koh, modified by Roger Bivand; shapelib by Frank Warmerdam}

\note{From maptools 0.4-7, this function is placed in the user-visible namespace on a trial basis, and reports of any malfunction should be sent to the package maintainer, Roger Bivand \email{Roger.Bivand@nhh.no}. It is likely that this function and its arguments will be changed.}

\seealso{\code{\link{write.pointShape}}, \code{\link{dbf.write}}}
\examples{
col_orig <- read.shape(system.file("shapes/columbus.shp", package="maptools")[1])
mappolys <- Map2poly(col_orig, as.character(col_orig$att.data$NEIGNO), raw=FALSE)
plot(mappolys)
col_df <- col_orig$att.data
col_cheap <- subset(mappolys, col_df$HOVAL < 34)
col_df_cheap <- subset(col_df, col_df$HOVAL < 34)
file <- tempfile("")
write.polylistShape(col_cheap, col_df_cheap, file)
getinfo.shape(paste(file, ".shp", sep=""))
col_new <- read.shape(paste(file, ".shp", sep=""))
mappolys <- Map2poly(col_new, as.character(col_new$att.data$NEIGNO), raw=FALSE)
plot(mappolys, border="red", add=TRUE)
}
\keyword{spatial}

