% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/march.dcmm.R
\name{march.dcmm.viterbi}
\alias{march.dcmm.viterbi}
\title{Viterbi algorithm for a DCMM model.}
\usage{
march.dcmm.viterbi(d, y)
}
\arguments{
\item{d}{The \code{\link[=march.Dcmm-class]{march.Dcmm-class}} on which to compute the most likely sequences of hidden states.}

\item{y}{The \code{\link[=march.Dataset-class]{march.Dataset-class}} to consider.}
}
\value{
A list of vectors containing the most likely sequences of hidden states, considering the given model for each sequence of the given dataset.
}
\description{
Viterbi algorithm for a DCMM model.
}
\examples{
# Estimation of a DCMM  
set.seed(327)
# Computation of a the simplest DCMM model
model <- march.dcmm.construct(y=pewee,orderHC=1,orderVC=1,M=2,popSize=1,gen=1)
# Extraction of the best sequence of hidden states using the Viterbi algorithm.
bestSeq <- march.dcmm.viterbi(model,pewee)
print(bestSeq)
}
\author{
Ogier Maitre
}

