% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/march.mc.R
\name{march.mc.construct}
\alias{march.mc.construct}
\title{Construct an homogeneous Markov Chain.}
\usage{
march.mc.construct(y, order, maxOrder = order)
}
\arguments{
\item{y}{the \code{\link[=march.Dataset-class]{march.Dataset}} from which the homogeneous Markov chain will be constructed.}

\item{order}{the order of the constructed Markov Chain.}

\item{maxOrder}{the maximum visible order among the set of Markovian models to compare.}
}
\value{
the \code{\link[=march.Mc-class]{march.Mc}} of order \emph{order} constructed \emph{w.r.t} the dataset \emph{y} and maxOrder.
}
\description{
A \code{\link[=march.Mc-class]{march.Mc}} object of order \emph{order} is constructed from
the dataset \emph{y}. The first maxOrder-order elements of each sequence of the dataset are truncated in order to return a model
which can be compared with other Markovian models of visible order maxOrder.
}
\examples{
# pewee dataset is a data object of the march package in march.Dataset class format.
model <- march.mc.construct(pewee,2)

# print the reduced form of the transition matrix of the Markovian Model.
print(model@RC)
}
\author{
Ogier Maitre
}
\seealso{
\code{\link[=march.Mc-class]{march.Mc-class}}, \code{\link{march.Model-class}}, \code{\link[=march.Dataset-class]{march.Dataset-class}}.
}

