% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kfold.R
\name{kfold_grid}
\alias{kfold_grid}
\title{Create k grid based folds for cross-validation}
\usage{
kfold_grid(data, k = 4, lonlat = TRUE)
}
\arguments{
\item{data}{Matrix or dataframe. The first two columns should represent the
longitude and latitude (or x,y coordinates if \code{lonlat = FALSE}).}

\item{k}{Integer. The number of folds (partitions) that have to be created.
This should be a square number (e.g 4, 9, 16). By default 4 folds are created.}

\item{lonlat}{Logical. If \code{TRUE} (default) then the dateline is taken
into account (see details) else if \code{FALSE} quantiles of x and y are used as
splitting points}
}
\value{
A vector with fold numbers ranging from 1 to k.
}
\description{
\code{kfold_grid} creates a k-fold partitioning of geographical data for
cross-validation based on spatial grid partitioning. Returns a vector with
fold numbers ranging from 1 to k.
}
\details{
If \code{lonlat = TRUE} then the data is first split along the
longitude based on a random starting point and then splitting in parts with
\code{k/2 points} while crossing the dateline. Then each part is splitted
along quantiles of the latitude in each part.
}
\examples{
set.seed(42)
lonlat_data <- cbind(runif(11, -180, 180), runif(11, -90, 90))
folds <- kfold_grid(lonlat_data, k = 4)
plot_folds(lonlat_data, folds)

# for x,y data
xy_data <- cbind(runif(11, 0, 100), runif(11, 0, 100))
folds <- kfold_grid(xy_data, k = 4, lonlat = FALSE)
plot_folds(xy_data, folds)

}
\seealso{
\code{\link{plot_folds}}, \code{\link{kfold_disc}},
  \code{\link[dismo]{kfold}}, , \code{\link{kfold_occurrence_background}}
}

