% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{labels}
\alias{labels}
\alias{assign_labels}
\alias{assign_labels.default}
\alias{assign_labels.data.frame}
\alias{get_labels}
\alias{get_labels.default}
\alias{get_labels.data.frame}
\alias{view_labels}
\alias{remove_labels}
\alias{remove_labels.default}
\alias{remove_labels.data.frame}
\title{Dataframe labels}
\usage{
assign_labels(x, ...)

\method{assign_labels}{default}(x, label, ...)

\method{assign_labels}{data.frame}(x, ..., .missing = c("error", "warn", "skip"), .ls = list(...))

get_labels(x)

\method{get_labels}{default}(x)

\method{get_labels}{data.frame}(x)

view_labels(x, title)

remove_labels(x, ...)

\method{remove_labels}{default}(x, ...)

\method{remove_labels}{data.frame}(x, cols, ...)
}
\arguments{
\item{x}{A vector of data.frame}

\item{...}{One or more unquoted expressed separated by commas.  If assigning
to a data.frame, \code{...} can be replaced with a \code{data.frame} where the first
column is the targeted colname and the second is the desired label.}

\item{label}{A single length string of a label to be assigned}

\item{.missing}{A control setting for dealing missing columns in a list;
can be set to \code{error} to \code{stop()} the call, \code{warn} to provide a warning, or
\code{skip} to silently skip those labels.}

\item{.ls}{A named list of columns and labels to be set if \code{...} is empty}

\item{title}{Title for the viewer window -- if not supplemented will show as
\code{paste0(as.character(substitute(x)), " - Labels")}}

\item{cols}{A character vector of column names; if missing will remove the
label attribute across all columns}
}
\value{
A labelled vector or \code{data.frame}
}
\description{
Assign labels to a vector or data.frame.
}
\details{
When labels are assigned to a data.frame they can make viewing the object
(with \code{View()} inside Rstudio).  The \code{view_labels()} has a call to \code{View()}
inside and will retrieve the labels and show them in the viewer as a
data.frame.
}
\examples{
labs <- assign_labels(
  iris,
  Sepal.Length = "cms",
  Sepal.Width  = "cms",
  Petal.Length = "cms",
  Petal.Width  = "cms",
  Species      = "Iris ..."
)

labs$dummy <- ""
get_labels(labs) # shows label as <NA> for dummy column

labs0 <- remove_labels(labs, c("Sepal.Length", "Sepal.Width"))
get_labels(labs0) # No labels for Sepal.Length and Sepal.Width
}
