% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_probabilistic.R
\name{hittingProbabilities}
\alias{hittingProbabilities}
\title{Hitting probabilities for markovchain}
\usage{
hittingProbabilities(markovchain)
}
\arguments{
\item{markovchain}{the markovchain-class object}
}
\value{
a matrix of hitting probabilities
}
\description{
Given a markovchain object,
this function calculates the probability of ever arriving from state i to j
}
\examples{
M <- matlab::zeros(5, 5)
M[1,1] <- M[5,5] <- 1
M[2,1] <- M[2,3] <- 1/2
M[3,2] <- M[3,4] <- 1/2
M[4,2] <- M[4,5] <- 1/2

markovChain <- new("markovchain", transitionMatrix = M)
hittingProbabilities(markovChain)
}
\references{
R. Vélez, T. Prieto, Procesos Estocásticos, Librería UNED, 2013
}
\author{
Ignacio Cordón
}
