% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ratio.R
\name{ratio}
\alias{ratio}
\title{Compute a ratio of two estimators}
\usage{
ratio(
  y_num,
  y_den,
  xsample,
  xpop,
  pi = NULL,
  pi2 = NULL,
  N = NULL,
  estimator = NULL,
  var_est = F,
  var_method = "LinHB",
  datatype = "raw",
  fpc = T,
  messages = T,
  ...
)
}
\arguments{
\item{y_num}{A vector containing the response value for each sampled unit in the numerator}

\item{y_den}{A vector containing the response value for each sampled unit in the denominator}

\item{xsample}{A vector containing the appropriate form of xsample for the estimator of choice. For example see ?mase::greg() to see the appropriate input for xsample when computing a ratio of two greg estimators}

\item{xpop}{A vector containing the appropriate form of xpop for the estimator of choice.}

\item{pi}{A vector containing the first order inclusion probabilities for the sample.}

\item{pi2}{Defaults to NULL. A vector containing the second order inclusion probabilities for the sample.}

\item{N}{The number of observations in the population.}

\item{estimator}{A string containing the name of the estimators of which you are taking a ratio of. The names follow the same format as the functions independently do in mase. Options are "horvitzThompson", "postStrat", and "greg".}

\item{var_est}{Default to FALSE, logical for whether or not to compute estimate of variance}

\item{var_method}{The method to use when computing the variance estimator.  Options are a Taylor linearized technique: "LinHB"= Hajek-Berger estimator, "LinHH" = Hansen-Hurwitz estimator, "LinHTSRS" = Horvitz-Thompson estimator under simple random sampling without replacement, and "LinHT" = Horvitz-Thompson estimator.}

\item{datatype}{Default to "raw", takes values "raw", "totals" or "means" for whether the user is providing the raw population stratum memberships, the population totals of each stratum, or the population proportions of each stratum.}

\item{fpc}{Default to TRUE, logical for whether or not the variance calculation should include a finite population correction when calculating the "LinHTSRS" or the "SRSbootstrap" variance estimator.}

\item{messages}{A logical indicating whether to output the messages internal to mase. Default is TRUE.}

\item{...}{Any additional arguments that can be passed to mase::horvitzThompson, mase::greg, and mase::postStrat}
}
\value{
A list of output containing:
\itemize{
\item{ratio_est:}{Estimate of the ratio of the population totals/means of the two estimators}
\item{variance_est:}{Estimate of the variance of the ratio of two estimators}
}
}
\description{
Compute a ratio of two estimators
}
\examples{
library(survey)
data(api) 
ratio(y_num = apisrs$api.stu, y_den = apisrs$enroll, xsample = apisrs$stype,
xpop = apipop$stype, pi = apisrs$pw^(-1), estimator = "postStrat",
var_est = TRUE, var_method = "LinHB", datatype = "raw")

}
\references{
\insertRef{coc77}{mase} 

\insertRef{sar92}{mase}
}
