% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihoods_origdata.R
\name{mash_compute_loglik}
\alias{mash_compute_loglik}
\title{Compute loglikelihood for fitted mash object on new data.}
\usage{
mash_compute_loglik(g, data, algorithm.version = c("Rcpp", "R"))
}
\arguments{
\item{g}{A mash object or the fitted_g from a mash object.}

\item{data}{A set of data on which to compute the loglikelihood.}

\item{algorithm.version}{Indicate R or Rcpp version}
}
\value{
The log-likelihood for data computed using g.
}
\description{
Compute loglikelihood for fitted mash object on new data.
}
\details{
The log-likelihood for each element is \eqn{p(Bhat_j |
  Shat_j,g,\alpha)} where \eqn{Bhat_j | B_j, Shat_j \sim N(B_j,
  Shat_j)} and \eqn{B_j/Shat_j^\alpha | Shat_j \sim g}.
}
\examples{
simdata = simple_sims(50,5,1)
data = mash_set_data(simdata$Bhat, simdata$Shat)
m = mash(data, cov_canonical(data))
mash_compute_loglik(m,data)

}
