% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polish.R
\name{polish}
\alias{polish}
\alias{polish_renaming}
\alias{polish_filter}
\alias{polish_transform_estimates}
\alias{polish_adjust_pvalue}
\title{Do some final polishing of the scrubbed mason analysis data.}
\usage{
polish_renaming(data, renaming.fun, columns = NULL)

polish_filter(data, keep.pattern, column)

polish_transform_estimates(data, transform.fun)

polish_adjust_pvalue(data, method = "BH")
}
\arguments{
\item{data}{The scrubbed object.}

\item{renaming.fun}{A function, typically with \code{\link[base:gsub]{base::gsub()}}, that
searches and replaces strings.}

\item{columns}{The columns to apply the renaming function to. Defaults to
columns that are a factor or character vectors.}

\item{keep.pattern}{Rows to keep based on a regular expression pattern.}

\item{column}{The column to apply the filtering to.}

\item{transform.fun}{A function to modify continuous variable columns.}

\item{method}{Correction method for the p-value adjustment
(\code{\link[stats:p.adjust]{stats::p.adjust()}}).}
}
\description{
Do some final polishing of the scrubbed mason analysis data.
}
\section{Functions}{
\itemize{
\item \code{polish_renaming}: \code{polish_renaming} simply takes a function, most
likely one that uses \code{\link[base:gsub]{base::gsub()}}, and uses that to search and
replace words, etc, in the specified columns.

\item \code{polish_filter}: \code{polish_filter} is basically a thin wrapper around
\code{\link[dplyr:filter]{dplyr::filter()}}, but using \code{\link[base:grepl]{base::grepl()}} for the
pattern searching.

\item \code{polish_transform_estimates}: \code{polish_transform_estimates} is simply a thin wrapper
around \code{\link[dplyr:mutate]{dplyr::mutate()}}.

\item \code{polish_adjust_pvalue}: \code{polish_adjust_pvalue} is a thin wrapper around
\code{\link[dplyr:mutate]{dplyr::mutate()}} and \code{\link[stats:p.adjust]{stats::p.adjust()}}
}}

\examples{
library(magrittr)
ds <- swiss \%>\%
 design('glm') \%>\%
 add_settings() \%>\%
 add_variables('yvar', c('Fertility', 'Education')) \%>\%
 add_variables('xvar', c('Agriculture', 'Catholic')) \%>\%
 add_variables('covariates', 'Examination') \%>\%
 construct() \%>\%
 scrub()
polish_renaming(ds, function(x) gsub('Education', 'Schooling', x))
polish_filter(ds, 'Xterm', 'term')
polish_adjust_pvalue(ds)[c('p.value', 'adj.p.value')]
polish_transform_estimates(ds, function(x) exp(x))
}
