% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circle_sections_figures.R
\name{pizza_4}
\alias{pizza_4}
\alias{s_pizza_4}
\alias{pizza_2}
\alias{s_pizza_2}
\alias{pizza_2_inv}
\alias{s_pizza_2_inv}
\title{Coordinates of a pizza with four slices}
\usage{
pizza_4(size.x = 15, shd = NA, lwd = 3, lty = 1)

s_pizza_4(size.x = 15, shd = NA, lwd = 3, lty = 1)

pizza_2(
  size.x = 15,
  size.y = 0,
  pos.x = 0,
  pos.y = 0,
  shd = NA,
  lty = 1,
  lwd = 3
)

s_pizza_2(
  size.x = 15,
  size.y = 0,
  pos.x = 0,
  pos.y = 0,
  shd = NA,
  lty = 1,
  lwd = 3
)

pizza_2_inv(
  size.x = 15,
  size.y = 0,
  pos.x = 0,
  pos.y = 0,
  shd = NA,
  lty = 1,
  lwd = 3
)

s_pizza_2_inv(
  size.x = 15,
  size.y = 0,
  pos.x = 0,
  pos.y = 0,
  shd = NA,
  lty = 1,
  lwd = 3
)
}
\arguments{
\item{size.x}{numeric, define the semi-major axis of the ellipse within which the figure is inscribed. Default is 15}

\item{shd}{character, define the shading of the figure. Default is NA which results in a transparent figure}

\item{lwd}{integer, define the line width of the figure. Default is 3}

\item{lty}{integer, define the line type of the figure, default is 1 (solid line)}

\item{size.y}{numeric, define the semi-minor axis of the ellipse within which the figure is inscribed. Default is 0}

\item{pos.x}{numeric, position on the x axis. Default is 0}

\item{pos.y}{numeric, position the y axis, Default is 0}
}
\value{
Return the coordinates for drawing four circle sections composing a pizza with four slices

Return the coordinates for drawing four circle sections composing a singledocu pizza with four slices

Return the coordinates for drawing two circle sections composing a pizza with two slices

Return the coordinates for drawing two circle sections composing a single pizza with two slices

The coordinates of two circle sections composing an inverse pizza with two slices

The coordinates of two circle sections composing a single pizza with two slices
}
\description{
Define the coordinates for drawing the circle sections composing a pizza with four slices
}
\section{Functions}{
\itemize{
\item \code{s_pizza_4()}: Coordinates of a single pizza with four slices

Define the coordinates for drawing the circle section composing a single pizza with four slices, to be used in shape()

\item \code{pizza_2()}: Coordinates of a pizza with two slices

Define the coordinates for drawing the circle sections composing a pizza with two slices

\item \code{s_pizza_2()}: Coordinates of a single pizza with two slices

Define the coordinates for drawing the circle section composing a single pizza with two slices, to be used in shape()

\item \code{pizza_2_inv()}: Coordinates of an inverse pizza with two slices

Define the coordinates for drawing the circle sections composing an inverse pizza with two slices

\item \code{s_pizza_2_inv()}: Coordinates of a single inverse pizza with two slices

Define the coordinates for drawing the circle sections composing an inverse pizza with two slices, to be used in shape()

}}
\examples{
# default coordinates of the pizza with four slices
pizza_4()
# default coordinates of the single pizza with four slices
s_pizza_4()
# default coordinates of the pizza with two slices
pizza_2()
# default coordinates of the single pizza with two slices
s_pizza_2()
# default coordinates of the inverse pizza with two slices
pizza_2_inv()
# default coordinates of the single inverse pizza with two slices
s_pizza_2_inv()
}
