% Generated by roxygen2 (4.0.2): do not edit by hand
\name{khb}
\alias{khb}
\title{Karlson-Holm-Breen method for comparing probit coefficients}
\usage{
khb(X, y, z)
}
\arguments{
\item{X}{data frame comprising independent variables including confounding variable.}

\item{y}{vector of dependent variable.}

\item{z}{character string giving the name of the confounding variable in \code{X}.}
}
\description{
Significance test for confounding; that is, the difference between regression
coefficients from same-sample nested logit and probit models. The test procedure follows
Karlson et al (2012), Section 3.4.
}
\examples{
## 1. load results from Klein (2014), Table 8
 data(klein14)
 M <- klein14$model.list

## 2. extract variables
 X <- do.call(rbind.data.frame, M$X); X <- X[,!names(X)=="0"]
 eta <- c(klein14$coefs$eta, rep(0, length(M$X)-length(M$W)))
 X <- cbind(X,eta)
 y <- unlist(M$R)

## 3. apply KHB method
khb(X=X, y=y, z="eta")
}
\author{
Thilo Klein
}
\references{
Karlson, K.B., A. Holm and R. Breen (2012). Comparing regression coefficients between same-sample nested models using logit and probit: A new method, \emph{Sociological Methodology}, 42(1):286--313.
}
\keyword{summary}

