/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.copy;

import choco.kernel.memory.copy.EnvironmentCopying;
import choco.kernel.memory.copy.RcBool;
import choco.kernel.memory.copy.RcDouble;
import choco.kernel.memory.copy.RcInt;
import choco.kernel.memory.copy.RcIntVector;
import choco.kernel.memory.copy.RcLong;
import choco.kernel.memory.copy.RcObject;
import choco.kernel.memory.copy.RcVector;
import choco.kernel.memory.copy.RecomputableElement;
import gnu.trove.TIntObjectHashMap;

public final class RcSave
implements RecomputableElement {
    public RecomputableElement[][] currentElement;
    private int lastSavedWorldIndex;
    private static TIntObjectHashMap<int[]> saveInt = new TIntObjectHashMap();
    private static TIntObjectHashMap<Object[][]> saveVector = new TIntObjectHashMap();
    private static TIntObjectHashMap<int[][]> saveIntVector = new TIntObjectHashMap();
    private static TIntObjectHashMap<boolean[]> saveBool = new TIntObjectHashMap();
    private static TIntObjectHashMap<long[]> saveLong = new TIntObjectHashMap();
    private static TIntObjectHashMap<double[]> saveDouble = new TIntObjectHashMap();
    private static TIntObjectHashMap<Object[]> saveObject = new TIntObjectHashMap();

    public RcSave(EnvironmentCopying env) {
        this.lastSavedWorldIndex = env.getWorldIndex();
        this.clear();
    }

    public void clear() {
        saveInt.clear();
        saveVector.clear();
        saveIntVector.clear();
        saveBool.clear();
        saveLong.clear();
        saveDouble.clear();
        saveObject.clear();
    }

    public void save(int worldIndex) {
        if (this.lastSavedWorldIndex >= worldIndex) {
            this.lastSavedWorldIndex = 0;
        }
        boolean[] tmpbool = new boolean[this.currentElement[0].length];
        int i = this.currentElement[0].length;
        while (--i >= 0) {
            tmpbool[i] = ((RcBool)this.currentElement[0][i]).deepCopy();
        }
        saveBool.put(worldIndex, tmpbool);
        int[] tmpint = new int[this.currentElement[1].length];
        int i2 = this.currentElement[1].length;
        while (--i2 >= 0) {
            tmpint[i2] = ((RcInt)this.currentElement[1][i2]).deepCopy();
        }
        saveInt.put(worldIndex, tmpint);
        Object[][] tmpvec = new Object[this.currentElement[2].length][];
        int i3 = this.currentElement[2].length;
        while (--i3 >= 0) {
            if (worldIndex != 0 && this.lastSavedWorldIndex >= this.currentElement[2][i3].getTimeStamp()) {
                tmpvec[i3] = saveVector.get(this.lastSavedWorldIndex)[i3];
                continue;
            }
            tmpvec[i3] = ((RcVector)this.currentElement[2][i3]).deepCopy();
        }
        saveVector.put(worldIndex, tmpvec);
        int[][] tmpintvec = new int[this.currentElement[3].length][];
        int i4 = this.currentElement[3].length;
        while (--i4 >= 0) {
            if (worldIndex != 0 && this.lastSavedWorldIndex >= this.currentElement[3][i4].getTimeStamp()) {
                tmpintvec[i4] = saveIntVector.get(this.lastSavedWorldIndex)[i4];
                continue;
            }
            tmpintvec[i4] = ((RcIntVector)this.currentElement[3][i4]).deepCopy();
        }
        saveIntVector.put(worldIndex, tmpintvec);
        long[] tmplong = new long[this.currentElement[6].length];
        int i5 = this.currentElement[6].length;
        while (--i5 >= 0) {
            tmplong[i5] = ((RcLong)this.currentElement[6][i5]).deepCopy();
        }
        saveLong.put(worldIndex, tmplong);
        double[] tmpdouble = new double[this.currentElement[7].length];
        int i6 = this.currentElement[7].length;
        while (--i6 >= 0) {
            tmpdouble[i6] = ((RcDouble)this.currentElement[7][i6]).deepCopy();
        }
        saveDouble.put(worldIndex, tmpdouble);
        Object[] tmpobject = new Object[this.currentElement[8].length];
        int i7 = this.currentElement[8].length;
        while (--i7 >= 0) {
            if (worldIndex != 0 && this.lastSavedWorldIndex >= this.currentElement[8][i7].getTimeStamp()) {
                tmpobject[i7] = saveObject.get(this.lastSavedWorldIndex)[i7];
                continue;
            }
            tmpobject[i7] = ((RcObject)this.currentElement[8][i7]).deepCopy();
        }
        saveObject.put(worldIndex, tmpobject);
        this.lastSavedWorldIndex = worldIndex;
    }

    public void restore(int worldIndex) {
        boolean[] tmpbool = saveBool.get(worldIndex);
        int[] tmpint = saveInt.get(worldIndex);
        Object[][] tmpvec = saveVector.get(worldIndex);
        int[][] tmpintvec = saveIntVector.get(worldIndex);
        long[] tmplong = saveLong.get(worldIndex);
        double[] tmpdouble = saveDouble.get(worldIndex);
        Object[] tmpobject = saveObject.get(worldIndex);
        int i = tmpbool.length;
        while (--i >= 0) {
            ((RcBool)this.currentElement[0][i])._set(tmpbool[i], worldIndex);
        }
        i = tmpint.length;
        while (--i >= 0) {
            ((RcInt)this.currentElement[1][i])._set(tmpint[i], worldIndex);
        }
        i = tmpvec.length;
        while (--i >= 0) {
            ((RcVector)this.currentElement[2][i])._set(tmpvec[i], worldIndex);
        }
        i = tmpintvec.length;
        while (--i >= 0) {
            ((RcIntVector)this.currentElement[3][i])._set(tmpintvec[i], worldIndex);
        }
        i = tmplong.length;
        while (--i >= 0) {
            ((RcLong)this.currentElement[6][i])._set(tmplong[i], worldIndex);
        }
        i = tmpdouble.length;
        while (--i >= 0) {
            ((RcDouble)this.currentElement[7][i])._set(tmpdouble[i], worldIndex);
        }
        i = tmpobject.length;
        while (--i >= 0) {
            ((RcObject)this.currentElement[8][i])._set(tmpobject[i], worldIndex);
        }
        if (worldIndex == 0) {
            this.clearMaps();
        } else {
            this.remove(worldIndex + 1);
        }
    }

    public void remove(int worldIndex) {
        saveInt.remove(worldIndex);
        saveVector.remove(worldIndex);
        saveIntVector.remove(worldIndex);
        saveBool.remove(worldIndex);
        saveLong.remove(worldIndex);
        saveDouble.remove(worldIndex);
        saveObject.remove(worldIndex);
    }

    private void clearMaps() {
        saveInt.clear();
        saveVector.clear();
        saveIntVector.clear();
        saveBool.clear();
        saveLong.clear();
        saveDouble.clear();
        saveObject.clear();
    }

    @Override
    public int getType() {
        return -1;
    }

    @Override
    public int getTimeStamp() {
        return 0;
    }
}

