/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.structure;

import choco.kernel.common.util.iterators.DisposableIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.structure.PartiallyStoredIntVector;
import choco.kernel.memory.structure.PartiallyStoredVector;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.propagation.Propagator;
import choco.kernel.solver.propagation.event.ConstraintEvent;

public abstract class APartiallyStoredCstrList<C extends SConstraint> {
    protected final PartiallyStoredVector<C> elements;
    protected final PartiallyStoredIntVector indices;
    protected final IStateInt priority;

    protected APartiallyStoredCstrList(IEnvironment env) {
        this.elements = env.makePartiallyStoredVector();
        this.indices = env.makePartiallyStoredIntVector();
        this.priority = env.makeInt(ConstraintEvent.UNARY);
    }

    public final C getConstraint(int i) {
        return (C)((SConstraint)this.elements.get(i));
    }

    public final int getConstraintIndex(int constraintIndex) {
        return this.indices.get(constraintIndex);
    }

    public final int getNbConstraints() {
        return this.elements.size();
    }

    public final PartiallyStoredVector<C> getConstraintVector() {
        return this.elements;
    }

    public final PartiallyStoredIntVector getIndexVector() {
        return this.indices;
    }

    public int eraseConstraint(SConstraint c) {
        int idx = this.elements.remove(c);
        this.indices.remove(idx);
        return idx;
    }

    public int addConstraint(SConstraint c, int varIdx, boolean dynamicAddition) {
        int constraintIdx;
        if (dynamicAddition) {
            constraintIdx = this.elements.add(c);
            this.indices.add(varIdx);
        } else {
            constraintIdx = this.elements.staticAdd(c);
            this.indices.staticAdd(varIdx);
        }
        this.computePriority(c);
        return constraintIdx;
    }

    protected void computePriority(SConstraint c) {
        this.priority.set(Math.max(this.priority.get(), ((Propagator)((Object)c)).getPriority()));
    }

    public final DisposableIterator<SConstraint> getConstraintsIterator() {
        return this.elements.getIterator();
    }

    public final int getPriority() {
        return this.priority.get();
    }
}

