% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repmat.R
\name{repmat}
\alias{repmat}
\title{Repeat matrix}
\usage{
repmat(mx, n)
}
\arguments{
\item{mx}{matrix}

\item{n}{either a scalar with the number of replications in both rows and
columns or a <= 3-length vector with individual repetitions.}
}
\value{
matrix replicated over \code{ncol(mx) * n} columns and \code{nrow(mx) * n} rows
}
\description{
Repeats a matrix over n columns and rows
}
\details{
This function was created to replicate the behavior of a homonymous
function on Matlab
}
\note{
The Matlab implementation of this function accepts \code{n} with length > 2.

It should also be noted that a concatenated vector in R, e.g. \code{c(5, 2)},
becomes a column vector when coerced to matrix, even though it may look like
a row vector at first glance. This is important to keep in mind when
considering the expected output of this function. Vectors in R make sense to
be seen as column vectors, given R's Statistics-oriented paradigm where
variables are usually disposed as columns in a dataset.
}
\examples{
x <- matrix(1:4, 2)
repmat(x, 1)
repmat(x, 2)
repmat(x, c(2, 3))
}
