% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_metrics_signif.R
\name{sim_metrics_signif}
\alias{sim_metrics_signif}
\title{Report p-values for metrics}
\usage{
sim_metrics_signif(
  metrics,
  background_type,
  level_identifier,
  metric_name,
  ...
)
}
\arguments{
\item{metrics}{Metrics data frame, containing at least two columns
\code{"sim_stat_signal_n_{background_type}_{level_identifier}"} and
\code{"sim_stat_background_n_{background_type}_{level_identifier}"}.}

\item{background_type}{Background type. Either \code{"ref"} or \code{"non_rep"}.}

\item{level_identifier}{Level identifier. Either \code{"i"} (Level 1_0) or \code{"g"} (Level 2_1).}

\item{metric_name}{name of metric. Only \code{"average_precision"} is currently implemented.}

\item{...}{arguments passed downstream.}
}
\value{
Metrics data frame containing two extra columns: the -log10 p-value and q-value of the specified metric
\code{"sim_retrieval_average_precision_{background_type}_{level_identifier}_nlog10pvalue"}
}
\description{
Report p-values for metrics
}
