% Generated by roxygen2 (4.0.2): do not edit by hand
\name{optim.GCCA}
\alias{optim.GCCA}
\title{GSCA optimization criterion}
\usage{
optim.GCCA(matrixpls.res, innerEstimator, ...)
}
\arguments{
\item{matrixpls.res}{An object of class \code{matrixpls} from which the
criterion function is calculated}

\item{innerEstimator}{A function used for inner estimation. Setting this argument to
\code{null} will use identity matrix as inner estimates and causes the algorithm to converge
after the first iteration. This is useful when using
\code{\link{outer.fixedWeights}} or some other outer estimation function that
does not use inner estimation results. The default is \code{\link{inner.path}}
(PLS path weighting scheme).}

\item{...}{All other arguments are passed through to \code{outerEstimators} and \code{innerEstimator}.}
}
\value{
Sum of residual variances.
}
\description{
GSCA optimization criterion
}
\details{
Optimization criterion for maximixing the weighted sum of composite
correlations
}
\references{
Tenenhaus, A., & Tenenhaus, M. (2011). Regularized Generalized Canonical
Correlation Analysis. Psychometrika, 76(2), 257–284. doi:10.1007/s11336-011-9206-8
}
\seealso{
Other Weight optimization criteria: \code{\link{optim.GSCA}};
  \code{\link{optim.maximizeInnerR2}};
  \code{\link{optim.maximizePrediction}}
}

