% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Unary.R
\name{hatize_byname}
\alias{hatize_byname}
\title{Creates a diagonal "hat" matrix from a vector}
\usage{
hatize_byname(v, keep = NULL)
}
\arguments{
\item{v}{The vector from which a "hat" matrix is to be created.}

\item{keep}{One of "rownames" or "colnames" or \code{NULL}.
If \code{NULL}, the default, names are kept from
the dimension that is not size 1.}
}
\value{
A square "hat" matrix with size equal to the length of \code{v}.
}
\description{
A "hat" matrix (or a diagonal matrix) is one in which the only non-zero elements are along on the diagonal.
To "hatize" a vector is to place its elements on the diagonal of an otherwise-zero square matrix.
\code{v} must be a matrix object with at least one of its two dimensions of length 1 (i.e., a vector).
The names on both dimensions of the hatized matrix are the same and taken from
the dimension of \code{v} that is \emph{not} 1.
Note that the row names and column names are sorted prior to forming the "hat" matrix.
}
\details{
Hatizing a 1x1 vector is potentially undefined.
The argument \code{keep}
determines whether to keep "rownames" or "colnames".
By default \code{keep} is \code{NULL},
meanding that the function should attempt to figure out which dimension's names
should be used for the hatized matrix on output.
If vector \code{v} could ever be 1x1,
it is best to set a value for \code{keep} when writing code
that calls \code{hatize_byname()}.

If the caller specifies \code{keep = "colnames"} when \code{v} is a column vector,
an error is thrown.
If the caller specifies \code{keep = "rownames"} when \code{v} is a row vector,
an error is thrown.
}
\examples{
v <- matrix(1:10, ncol = 1, dimnames = list(c(paste0("i", 1:10)), c("c1"))) \%>\%
  setrowtype("Industries") \%>\% setcoltype(NA)
hatize_byname(v, keep = "rownames")
r <- matrix(1:5, nrow = 1, dimnames = list(c("r1"), c(paste0("c", 1:5)))) \%>\%
  setrowtype(NA) \%>\% setcoltype("Commodities")
hatize_byname(r, keep = "colnames")
# This also works with lists.
hatize_byname(list(v, v), keep = "rownames")
# A 1x1 column vector is a degenerate case. 
# Row names and rowtype are transferred to the column.
matrix(42, nrow = 1, ncol = 1, dimnames = list("r1")) \%>\% 
  setrowtype("Product -> Industry") \%>\% 
  hatize_byname(keep = "rownames")
# A 1x1 row vector is a degenerate case. 
# Column names and coltype are transferred to the row.
matrix(42, nrow = 1, ncol = 1, dimnames = list(NULL, "c1")) \%>\% 
  setcoltype("Industry -> Product") \%>\% 
  hatize_byname(keep = "colnames")
# A 1x1 matrix with both row and column names generates a failure.
\dontrun{
matrix(42, nrow = 1, ncol = 1, dimnames = list("r1", "c1")) \%>\% 
  setrowtype("Product -> Industry") \%>\% 
  setcoltype("Industry -> Product") \%>\% 
  hatize_byname()
}
# But you could specify which you want keep, row names or column names.
m <- matrix(42, nrow = 1, ncol = 1, dimnames = list("r1", "c1")) \%>\% 
  setrowtype("Product -> Industry") \%>\% 
  setcoltype("Industry -> Product")
m \%>\% 
  hatize_byname(keep = "rownames")
m \%>\% 
  hatize_byname(keep = "colnames")
}
