% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Unary.R
\name{colsums_byname}
\alias{colsums_byname}
\title{Column sums, sorted by name}
\usage{
colsums_byname(a, rowname = NA)
}
\arguments{
\item{a}{a matrix or list of matrices from which column sums are desired.}

\item{rowname}{name of the output row containing column sums.}
}
\value{
a row vector of type \code{matrix} containing the column sums of \code{a}.
}
\description{
Calculates column sums for a matrix by premultiplying by an identity vector (containing all 1's).
In contrast to \code{colSums} (which returns a \code{numeric} result),
the return value from \code{colsums_byname} is a matrix.
An optional \code{rowname} for the resulting row vector can be supplied.
If \code{rowname} is \code{NA} (the default),
the row name is set to the row type as given by \code{rowtype(a)}.
If \code{rowname} is set to \code{NULL}, the row name is returned empty.
}
\examples{
library(dplyr)
m <- matrix(c(1:6), nrow = 2, dimnames = list(paste0("i", 1:2), paste0("c", 3:1))) \%>\%
  setrowtype("Industries") \%>\% setcoltype("Commodities")
m
colsums_byname(m)
colsums_byname(m, rowname = "E.ktoe")
m \%>\% 
  colsums_byname() \%>\% 
  rowsums_byname()
# This also works with lists
colsums_byname(list(m, m))
colsums_byname(list(m, m), rowname = "E.ktoe")
colsums_byname(list(m, m), rowname = NA)
colsums_byname(list(m, m), rowname = NULL)
DF <- data.frame(m = I(list()))
DF[[1,"m"]] <- m
DF[[2,"m"]] <- m
colsums_byname(DF$m[[1]])
colsums_byname(DF$m)
colsums_byname(DF$m, "sums")
res <- DF \%>\% mutate(
  cs = colsums_byname(m),
  cs2 = colsums_byname(m, rowname = "sum")
)
res$cs2
}
