% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Unary.R
\name{hatinv_byname}
\alias{hatinv_byname}
\title{Hatize and invert a vector}
\usage{
hatinv_byname(v, keep = NULL, inf_becomes = .Machine$double.xmax)
}
\arguments{
\item{v}{The vector to be hatized and inverted.}

\item{keep}{See \code{hatize_byname()}.}

\item{inf_becomes}{A value to be substitute for any \code{Inf} produced by the inversion process.
Default is \code{.Machine$double.xmax}.
If \code{FALSE} (the default), \code{Inf} is not handled differently.
If \code{TRUE}, \code{Inf} values in the resulting matrix are converted to zeroes.}
}
\value{
a square diagonal matrix with inverted elements of \code{v} on the diagonal
}
\description{
When dividing rows or columns of a matrix by elements of a vector,
the vector elements are placed on the diagonal of a new matrix,
the diagonal matrix is inverted, and
the result is pre- or post-multiplied into the matrix.
This function performs the hatizing and inverting of vector \code{v} in one step
and takes advantage of computational efficiencies to achieve the desired result.
The computational shortcut is apparent when one observes that the matrix produced by hatizing and inverting
a vector is a diagonal matrix whose non-zero elements are the numerical inverses of the individual elements of \code{v}.
So this function first inverts each element of \code{v} then places the inverted elements on the diagonal of a diagonal matrix.
}
\details{
Note that this function gives the same result as \code{invert_byname(hatize_byname(v))},
except that \code{invert_byname(hatize_byname(v))} fails due to a singular matrix error
when any of the elements of \code{v} are zero.
This function will give \code{inf_becomes} on the diagonal of the result for each zero element of \code{v},
arguably a better answer.
The sign of \code{Inf} is preserved in the substitution.
The default value of \code{Inf_becomes} is \code{.Machine$double.xmax}.
Set \code{inf_becomes} to \code{NULL} to disable this behavior.

The default behavior is helpful for cases when the result of \code{hatinv_byname()} is later multiplied by \code{0}
to obtain \code{0}.
Multiplying \code{Inf} by \code{0} gives \code{NaN} which would effectively end the stream of calculations.
}
\examples{
v <- matrix(1:10, ncol = 1, dimnames = list(c(paste0("i", 1:10)), c("c1"))) \%>\%
  setrowtype("Industries") \%>\% setcoltype(NA)
r <- matrix(1:5, nrow = 1, dimnames = list(c("r1"), c(paste0("c", 1:5)))) \%>\%
  setrowtype(NA) \%>\% setcoltype("Commodities")
hatinv_byname(v, keep = "rownames")
hatinv_byname(r, keep = "colnames")
# This function also works with lists.
hatinv_byname(list(v, v), keep = "rownames")
# Watch out for 0 values
v2 <- matrix(0:1, ncol = 1, dimnames = list(c(paste0("i", 0:1)), c("p1"))) \%>\%
  setrowtype("Industries") \%>\% setcoltype(NA)
# Produces singular matrix error
\dontrun{v2 \%>\% hatize_byname() \%>\% invert_byname}
# Handles 0 values well
hatinv_byname(v2, keep = "rownames")
hatinv_byname(v2, inf_becomes = 42, keep = "rownames")
hatinv_byname(v2, inf_becomes = NA, keep = "rownames")
# Deals with 1x1 matrices well, if the `keep` argument is set.
m <- matrix(42, nrow = 1, ncol = 1, dimnames = list("r1", "c1")) \%>\% 
  setrowtype("Product -> Industry") \%>\% 
  setcoltype("Industry -> Product")
m \%>\% 
  hatinv_byname(keep = "rownames")
m \%>\% 
  hatinv_byname(keep = "colnames")
}
