% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Binary.R
\name{quotient_byname}
\alias{quotient_byname}
\title{Name-wise matrix element division}
\usage{
quotient_byname(dividend, divisor)
}
\arguments{
\item{dividend}{Dividend matrix or constant}

\item{divisor}{Divisor matrix or constant}
}
\value{
A matrix representing the name-wise element quotient of \code{dividend} and \code{divisor}
}
\description{
Element-wise division of two matrices.
}
\details{
Performs a union and sorting of names of rows and columns for both \code{dividend} and \code{divisor}
prior to element division.
Zeroes are inserted for missing matrix elements.
Doing so ensures that
the dimensions of the \code{dividend} and \code{divisor} will be conformable.
}
\examples{
library(dplyr)
quotient_byname(100, 50)
commoditynames <- c("c1", "c2")
industrynames <- c("i1", "i2")
U <- matrix(1:4, ncol = 2, dimnames = list(commoditynames, industrynames)) \%>\%
  setrowtype("Commodities") \%>\% setcoltype("Industries")
G <- matrix(rev(1:4), ncol = 2, dimnames = list(rev(commoditynames), rev(industrynames))) \%>\%
  setrowtype("Commodities") \%>\% setcoltype("Industries")
U / G # Non-sensical.  Names aren't aligned
quotient_byname(U, G)
quotient_byname(U, 10)
quotient_byname(10, G)
# This also works with lists
quotient_byname(10, list(G,G))
quotient_byname(list(G,G), 10)
quotient_byname(list(U, U), list(G, G))
DF <- data.frame(U = I(list()), G = I(list()))
DF[[1,"U"]] <- U
DF[[2,"U"]] <- U
DF[[1,"G"]] <- G
DF[[2,"G"]] <- G
quotient_byname(DF$U, DF$G)
DF \%>\% mutate(elementquotients = quotient_byname(U, G))
}
