% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_beast2_pkg_installed.R
\name{is_beast2_pkg_installed}
\alias{is_beast2_pkg_installed}
\title{Is a BEAST2 package installed?}
\usage{
is_beast2_pkg_installed(name, has_internet = curl::has_internet())
}
\arguments{
\item{name}{the package's name}

\item{has_internet}{boolean to indicate if the user has access to the
internet. By default, this value equals the result
of \code{curl::has_internet}}
}
\value{
\itemize{
  \item \code{TRUE} if the BEAST2 package is installed
  \item \code{FALSE} if the BEAST2 package is not installed
  \item \code{NULL} if there is no internet connection
}
}
\description{
Checks if a BEAST2 package is installed.
}
\details{
To be able to check this, an internet connection is needed.
Without an internet connection, \code{NULL} is returned.
}
\examples{
\dontrun{
  is_beast2_pkg_installed("Beasy")
}
}
\seealso{
Use \link{is_beast2_ns_pkg_installed}
  to see if the NS package is installed without an internet connection
}
\author{
Richèl J.C. Bilderbeek
}
