% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mccf1.R
\name{plot.mccf1}
\alias{plot.mccf1}
\title{Plot the MCC-F1 curve}
\usage{
\method{plot}{mccf1}(x, main = "the MCC-F1 score curve", xlab = "F1 score",
  ylab = "normalized MCC", .curveFileName, ...)
}
\arguments{
\item{x}{"mccf1" object resulting from the function mccf1}

\item{main}{main title of the plot (default: "the MCC-F1 score curve")}

\item{xlab, ylab}{x- and y- axis annotation (default: "F1 score","normalized MCC")}

\item{.curveFileName}{character string, used for naming pdf file of the plot with \code{\link[grDevices]{pdf}} (if this argument is present, the plot will be stored in pdf with specified file name)}

\item{...}{further arguments passed to and from methods}
}
\value{
the ggplot object
}
\description{
This function plots the MCC-F1 score curve using ggplot.
}
\examples{
response <- c(rep(1, 1000), rep(0, 10000))
predictor <- c(rbeta(300, 12, 2), rbeta(700, 3, 4), rbeta(10000, 2, 3))
plot(mccf1(response, predictor))
}
